/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceDelegator;
import org.wikitty.hessian.WikittyHessianFactory;

public class WikittyServiceSlave
extends WikittyServiceDelegator
implements PacketListener {
    private static Log log = LogFactory.getLog(WikittyServiceSlave.class);
    protected String room;
    protected String pseudo;
    protected WikittyService master;
    protected ApplicationConfig config;
    protected long lastState = -1L;
    protected RandomAccessFile syncStateFile = null;
    protected int syncIntervale = 300;
    protected long lastStateSaveDate = -1L;

    public WikittyServiceSlave(ApplicationConfig config, WikittyService ws) {
        super(ws);
        this.config = config;
        File file = config.getOptionAsFile(WikittyConfigOption.WIKITTY_SLAVE_SYNC_STATE_FILE.getKey());
        if (!file.exists()) {
            throw new WikittyException(String.format("File state %s doesn't exists. You must initialise data correctly and create state file after that before used WikittyServiceSlave", file));
        }
        try {
            this.syncStateFile = new RandomAccessFile(file, "rwd");
        }
        catch (FileNotFoundException eee) {
            throw new WikittyException("Can't create file to store slave state", (Throwable)eee);
        }
        this.syncIntervale = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SLAVE_SYNC_STATE_INTERVALE.getKey());
        String masterURL = config.getOption(WikittyConfigOption.WIKITTY_SLAVE_MASTER_URL.getKey());
        this.master = WikittyHessianFactory.getWikittyService(masterURL);
        this.initXMPP(config);
    }

    protected long getLastState() {
        if (this.lastState == -1L) {
            try {
                this.syncStateFile.seek(0L);
                this.lastState = this.syncStateFile.readLong();
            }
            catch (IOException eee) {
                throw new WikittyException("Can't read state file", (Throwable)eee);
            }
        }
        return this.lastState;
    }

    protected void setLastState(long date) {
        this.lastState = date;
        long now = System.currentTimeMillis();
        if (this.lastStateSaveDate + (long)this.syncIntervale < now) {
            try {
                this.syncStateFile.seek(0L);
                this.syncStateFile.writeLong(this.lastState);
                this.lastStateSaveDate = now;
            }
            catch (IOException eee) {
                log.error((Object)"Can't write state file", (Throwable)eee);
            }
        }
    }

    protected void initXMPP(ApplicationConfig config) {
        String server = config.getOption(WikittyConfigOption.WIKITTY_SLAVE_MASTER_XMPP_SERVER.getKey());
        this.room = config.getOption(WikittyConfigOption.WIKITTY_SLAVE_MASTER_XMPP_ROOM.getKey());
        this.pseudo = WikittyUtil.getUniqueLoginName();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Try to connect to xmpp serveur " + server + " with pseudo " + this.pseudo + " in room " + this.room));
            }
            XMPPConnection connection = new XMPPConnection(server);
            connection.connect();
            connection.loginAnonymously();
            DiscussionHistory history = new DiscussionHistory();
            long lastDate = this.getLastState();
            Date date = new Date(lastDate);
            history.setSince(date);
            MultiUserChat muc = new MultiUserChat(connection, this.room);
            muc.join(this.pseudo, "", history, 4000L);
            muc.addMessageListener((PacketListener)this);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't connect to xmpp serveur", (Throwable)eee);
        }
    }

    public void processPacket(Packet packet) {
        String name = this.room + "/" + this.pseudo;
        if (!name.equals(packet.getFrom())) {
            Object event = packet.getProperty("wikitty-event");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receive message : " + event));
            }
            if (event instanceof WikittyEvent) {
                this.processRemoteEvent((WikittyEvent)event);
            }
        }
    }

    protected void processRemoteEvent(WikittyEvent event) {
        this.replay(null, Collections.singletonList(event), true);
        this.setLastState(event.getTime());
    }

    public String login(String login, String password) {
        return this.master.login(login, password);
    }

    public void logout(String securityToken) {
        this.master.logout(securityToken);
    }

    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        return this.master.store(securityToken, wikitties, force);
    }

    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        return this.master.storeExtension(securityToken, exts);
    }

    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        return this.master.delete(securityToken, ids);
    }

    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        return this.master.deleteExtension(securityToken, extNames);
    }

    public WikittyEvent deleteTree(String securityToken, String wikittyId) {
        return this.master.deleteTree(securityToken, wikittyId);
    }

    public WikittyEvent clear(String securityToken) {
        return this.master.clear(securityToken);
    }
}

