/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.query.FacetQuery;
import org.nuiton.wikitty.query.FacetSortType;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;

public class WikittySearchEngineHelper {
    private static Log log = LogFactory.getLog(WikittySearchEngineHelper.class);

    public static WikittyQueryResult<String> findAllByQueryWithSelect(WikittySearchEngine searchEngine, WikittyTransaction transaction, WikittyQuery query) {
        boolean sortDesc;
        Condition newCond;
        if (!(query.getCondition() instanceof Select)) {
            throw new WikittyException("Query don't start with Select condition");
        }
        Select select = (Select)query.getCondition();
        if (WikittyExtension.isFqField(select.getElement().getValue())) {
            String extName = WikittyExtension.extractExtensionName(select.getElement().getValue());
            newCond = new WikittyQueryMaker().and().exteq(extName).condition(select.getSubCondition()).getCondition();
        } else {
            newCond = select.getSubCondition();
        }
        WikittyQuery queryFacet = query.copy();
        queryFacet.setCondition(newCond);
        queryFacet.setLimit(0);
        WikittyQuery querySelect = queryFacet.copy();
        querySelect.setLimit(0);
        querySelect.setFacetMinCount(1);
        querySelect.setFacetLimit(Integer.MAX_VALUE);
        querySelect.setFacetSort(FacetSortType.name);
        querySelect.setFacetQuery(new FacetQuery[0]);
        querySelect.setFacetField(select.getElement());
        WikittyQueryResult<String> resultFacet = searchEngine.findAllByQuery(transaction, queryFacet);
        WikittyQueryResult<String> resultSelect = searchEngine.findAllByQuery(transaction, querySelect);
        List<FacetTopic> topics = resultSelect.getFacets().get(select.getElement().getValue());
        List<String> selectList = new ArrayList<String>(topics.size());
        if (query.getOffset() < topics.size()) {
            for (FacetTopic topic : topics) {
                selectList.add(topic.getTopicName());
            }
        }
        if (sortDesc = query.getSortDescending().contains(select.getElement())) {
            Collections.reverse(selectList);
        }
        if (query.getOffset() < topics.size()) {
            int offset = query.getOffset();
            int last = Math.min(topics.size(), query.getOffset() + query.getLimit());
            selectList = selectList.subList(offset, last);
        }
        if (select.getAggregate() != null) {
            switch (select.getAggregate()) {
                case AVG: {
                    BigDecimal result = new BigDecimal(0);
                    for (String s : selectList) {
                        BigDecimal v = WikittyUtil.toBigDecimal(s);
                        result = result.add(v);
                    }
                    result = result.divide(new BigDecimal(selectList.size()));
                    selectList = new ArrayList();
                    selectList.add(WikittyUtil.toString(result));
                    break;
                }
                case COUNT: {
                    BigDecimal result = new BigDecimal(selectList.size());
                    selectList = new ArrayList();
                    selectList.add(WikittyUtil.toString(result));
                    break;
                }
                case MAX: {
                    if (selectList.isEmpty()) break;
                    String result = sortDesc ? (String)selectList.get(0) : (String)selectList.get(selectList.size() - 1);
                    selectList = new ArrayList();
                    selectList.add(WikittyUtil.toString(result));
                    break;
                }
                case MIN: {
                    if (selectList.isEmpty()) break;
                    String result = sortDesc ? (String)selectList.get(selectList.size() - 1) : (String)selectList.get(0);
                    selectList = new ArrayList();
                    selectList.add(WikittyUtil.toString(result));
                    break;
                }
                case SUM: {
                    BigDecimal result = new BigDecimal(0);
                    for (String s : selectList) {
                        BigDecimal v = WikittyUtil.toBigDecimal(s);
                        result = result.add(v);
                    }
                    selectList = new ArrayList();
                    selectList.add(WikittyUtil.toString(result));
                }
            }
        }
        WikittyQueryResult<String> result = new WikittyQueryResult<String>(query.getName(), query.getOffset(), topics.size(), resultSelect.getQueryString(), resultFacet.getFacets(), selectList, 0L, 0L);
        return result;
    }
}

