/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;

public class WikittyCopyOnWrite
implements Wikitty {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WikittyCopyOnWrite.class);
    protected Wikitty target;
    protected boolean targetIsACopy = false;

    public WikittyCopyOnWrite(Wikitty target) {
        this.target = target;
    }

    @Override
    public String getPreloadPattern() {
        return this.target.getPreloadPattern();
    }

    @Override
    public void setPreloadPattern(String preloadPattern) {
        if (!ObjectUtils.equals((Object)preloadPattern, (Object)this.getPreloadPattern())) {
            this.substituteTargetWithCopy();
            this.target.setPreloadPattern(preloadPattern);
        }
    }

    @Override
    public Set<String> getAllPreloadPattern() {
        return this.target.getAllPreloadPattern();
    }

    @Override
    public Map<String, Wikitty> getPreloaded() {
        return this.target.getPreloaded();
    }

    @Override
    public void setPreloaded(Map<String, Wikitty> preloaded) {
        this.substituteTargetWithCopy();
        this.target.setPreloaded(preloaded);
    }

    @Override
    public void addPreloaded(Wikitty w) {
        if (w != null && !this.getPreloaded().containsKey(w.getId())) {
            this.substituteTargetWithCopy();
            this.target.addPreloaded(w);
        }
    }

    @Override
    public void replaceWith(Wikitty w) {
        this.replaceWith(w, false);
    }

    @Override
    public void replaceWith(Wikitty w, boolean force) {
        if (this == w) {
            return;
        }
        this.substituteTargetWithCopy();
        this.target.replaceWith(w, force);
    }

    public Wikitty getTarget() {
        return this.target;
    }

    protected void substituteTargetWithCopy() {
        if (!this.targetIsACopy) {
            try {
                this.target = this.target.clone();
                this.targetIsACopy = true;
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " now has for target " + this.target));
                }
            }
            catch (CloneNotSupportedException eee) {
                throw new WikittyException(String.format("unable to clone wikitty %s", this.target), eee);
            }
        }
    }

    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public String toString(String extName) {
        return this.target.toString(extName);
    }

    @Override
    public String toStringAllField() {
        return this.target.toStringAllField();
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public Wikitty clone() throws CloneNotSupportedException {
        return this.target.clone();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.substituteTargetWithCopy();
        this.target.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.substituteTargetWithCopy();
        this.target.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.substituteTargetWithCopy();
        this.target.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.substituteTargetWithCopy();
        this.target.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getId() {
        return this.target.getId();
    }

    @Override
    public boolean isDeleted() {
        return this.target.isDeleted();
    }

    @Override
    public Date getDeleteDate() {
        return this.target.getDeleteDate();
    }

    @Override
    public void setDeleteDate(Date delete) {
        if (!ObjectUtils.equals((Object)delete, (Object)this.getDeleteDate())) {
            this.substituteTargetWithCopy();
            this.target.setDeleteDate(delete);
        }
    }

    @Override
    public void addExtension(WikittyExtension ext) {
        if (!this.target.getExtensions().contains(ext)) {
            this.substituteTargetWithCopy();
            this.target.addExtension(ext);
        }
    }

    @Override
    public void addExtension(Collection<WikittyExtension> exts) {
        if (!this.target.getExtensions().containsAll(exts)) {
            this.substituteTargetWithCopy();
            this.target.addExtension(exts);
        }
    }

    @Override
    public boolean hasExtension(String extName) {
        return this.target.hasExtension(extName);
    }

    @Override
    public boolean hasField(String extName, String fieldName) {
        return this.target.hasField(extName, fieldName);
    }

    @Override
    public boolean hasField(String fqfieldName) {
        return this.target.hasField(fqfieldName);
    }

    @Override
    public WikittyExtension getExtension(String ext) {
        return this.target.getExtension(ext);
    }

    @Override
    public Collection<String> getExtensionNames() {
        return this.target.getExtensionNames();
    }

    @Override
    public Collection<WikittyExtension> getExtensions() {
        return this.target.getExtensions();
    }

    @Override
    public Collection<WikittyExtension> getExtensionDependencies(String ext, boolean recursively) {
        return this.target.getExtensionDependencies(ext, recursively);
    }

    @Override
    public FieldType getFieldType(String fqfieldName) {
        return this.target.getFieldType(fqfieldName);
    }

    @Override
    public FieldType getFieldType(String extName, String fieldName) {
        return this.target.getFieldType(extName, fieldName);
    }

    @Override
    public void setField(String ext, String fieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.setField(ext, fieldName, value);
    }

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        return this.target.getFieldAsObject(ext, fieldName);
    }

    @Override
    public byte[] getFieldAsBytes(String ext, String fieldName) {
        return this.target.getFieldAsBytes(ext, fieldName);
    }

    @Override
    public boolean getFieldAsBoolean(String ext, String fieldName) {
        return this.target.getFieldAsBoolean(ext, fieldName);
    }

    @Override
    public BigDecimal getFieldAsBigDecimal(String ext, String fieldName) {
        return this.target.getFieldAsBigDecimal(ext, fieldName);
    }

    @Override
    public int getFieldAsInt(String ext, String fieldName) {
        return this.target.getFieldAsInt(ext, fieldName);
    }

    @Override
    public long getFieldAsLong(String ext, String fieldName) {
        return this.target.getFieldAsLong(ext, fieldName);
    }

    @Override
    public float getFieldAsFloat(String ext, String fieldName) {
        return this.target.getFieldAsFloat(ext, fieldName);
    }

    @Override
    public double getFieldAsDouble(String ext, String fieldName) {
        return this.target.getFieldAsDouble(ext, fieldName);
    }

    @Override
    public String getFieldAsString(String ext, String fieldName) {
        return this.target.getFieldAsString(ext, fieldName);
    }

    @Override
    public Date getFieldAsDate(String ext, String fieldName) {
        return this.target.getFieldAsDate(ext, fieldName);
    }

    @Override
    public String getFieldAsWikitty(String ext, String fieldName) {
        return this.target.getFieldAsWikitty(ext, fieldName);
    }

    @Override
    public Wikitty getFieldAsWikitty(String extName, String fieldName, boolean exceptionIfNotLoaded) {
        return this.target.getFieldAsWikitty(extName, fieldName, exceptionIfNotLoaded);
    }

    @Override
    public <E> List<E> getFieldAsList(String ext, String fieldName, Class<E> clazz) {
        return this.target.getFieldAsList(ext, fieldName, clazz);
    }

    @Override
    public List<Wikitty> getFieldAsWikittyList(String ext, String fieldName, boolean exceptionIfNotLoaded) {
        return this.target.getFieldAsWikittyList(ext, fieldName, exceptionIfNotLoaded);
    }

    @Override
    public <E> Set<E> getFieldAsSet(String ext, String fieldName, Class<E> clazz) {
        return this.target.getFieldAsSet(ext, fieldName, clazz);
    }

    @Override
    public Set<Wikitty> getFieldAsWikittySet(String ext, String fieldName, boolean exceptionIfNotLoaded) {
        return this.target.getFieldAsWikittySet(ext, fieldName, exceptionIfNotLoaded);
    }

    @Override
    public void addToField(String ext, String fieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.addToField(ext, fieldName, value);
    }

    @Override
    public void removeFromField(String ext, String fieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.removeFromField(ext, fieldName, value);
    }

    @Override
    public void clearField(String ext, String fieldName) {
        this.substituteTargetWithCopy();
        this.target.clearField(ext, fieldName);
    }

    @Override
    public void addToField(String fqFieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.addToField(fqFieldName, value);
    }

    @Override
    public void removeFromField(String fqFieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.removeFromField(fqFieldName, value);
    }

    @Override
    public void clearField(String fqFieldName) {
        this.substituteTargetWithCopy();
        this.target.clearField(fqFieldName);
    }

    @Override
    public Set<String> fieldNames() {
        return this.target.fieldNames();
    }

    @Override
    public Map<String, Object> getFieldValue() {
        return this.target.getFieldValue();
    }

    @Override
    public Set<String> getAllFieldNames() {
        return this.target.getAllFieldNames();
    }

    @Override
    public Object getFqField(String fqFieldName) {
        return this.target.getFqField(fqFieldName);
    }

    @Override
    public String getVersion() {
        return this.target.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.substituteTargetWithCopy();
        this.target.setVersion(version);
    }

    @Override
    public Set<String> getDirty() {
        return this.target.getDirty();
    }

    @Override
    public void clearDirty() {
        this.substituteTargetWithCopy();
        this.target.clearDirty();
    }

    @Override
    public void setFqField(String fieldName, Object value) {
        this.substituteTargetWithCopy();
        this.target.setFqField(fieldName, value);
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public boolean hasMetaExtension(String metaExtensionName, String extensionName) {
        return this.target.hasMetaExtension(metaExtensionName, extensionName);
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, WikittyExtension extension) {
        this.substituteTargetWithCopy();
        this.target.addMetaExtension(metaExtension, extension);
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, String extensionFqn) {
        this.substituteTargetWithCopy();
        this.target.addMetaExtension(metaExtension, extensionFqn);
    }
}

