/*
 * #%L
 * Wikitty :: hessian server
 * 
 * $Id: WikittyServerStart.java 1136 2011-08-12 14:24:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.6/wikitty-api/src/main/java/org/nuiton/wikitty/WikittyServerStart.java $
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

/**
 * Read wikitty config file and create WikittyService as asked in config.
 * WikittyService????Server must be declared in config file otherwize server
 * don't start
 *
 * @author poussin
 * @version $Revision: 1136 $
 * @since 3.1
 *
 * Last update: $Date: 2011-08-12 16:24:03 +0200 (ven, 12 aoû 2011) $
 * by : $Author: tchemit $
 */
public class WikittyServerStart {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServerStart.class);

    static public void main(String ... args) {
        ApplicationConfig config = WikittyConfig.getConfig(args);
        WikittyService ws = WikittyServiceFactory.buildWikittyService(config);
    }

}
