package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class TreeAbstract extends BusinessEntityImpl implements Tree {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionTree;

    @Override
    public String getType() {
String value = TreeHelper.getType(getWikitty());
return value;
}

    @Override
    public void setType(String type) {
String oldValue = getType();
TreeHelper.setType(getWikitty(), type);
getPropertyChangeSupport().firePropertyChange(Tree.FIELD_TREE_TYPE, oldValue, getType());
}

    public TreeAbstract() {
        super();
}

    public TreeAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public TreeAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionTree = new WikittyExtension(EXT_TREE,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                Vegetal.EXT_VEGETAL,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String type unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(VegetalAbstract.extensions); 
        // current after requires ones

        exts.add(extensionTree);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return TreeHelper.toString(getWikitty());
}

} //TreeAbstract
