package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class RealmAbstract extends BusinessEntityImpl implements Realm {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionRealm;

    @Override
    public String getName() {
String value = RealmHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
RealmHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(Realm.FIELD_REALM_NAME, oldValue, getName());
}

    @Override
    public String getTree() {
String value = RealmHelper.getTree(getWikitty());
return value;
}

    @Override
    public void setTree(String tree) {
String oldValue = getTree();
RealmHelper.setTree(getWikitty(), tree);
getPropertyChangeSupport().firePropertyChange(Realm.FIELD_REALM_TREE, oldValue, getTree());
}

    @Override
    public String getKing() {
String value = RealmHelper.getKing(getWikitty());
return value;
}

    @Override
    public void setKing(String king) {
String oldValue = getKing();
RealmHelper.setKing(getWikitty(), king);
getPropertyChangeSupport().firePropertyChange(Realm.FIELD_REALM_KING, oldValue, getKing());
}

    public RealmAbstract() {
        super();
}

    public RealmAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public RealmAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionRealm = new WikittyExtension(EXT_REALM,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\"", 
                                             "Wikitty tree unique=\"true\"", 
                                             "Wikitty king unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionRealm);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return RealmHelper.toString(getWikitty());
}

} //RealmAbstract
