/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyExtensionMigration.java 1300 2012-01-07 20:40:21Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.3/wikitty-api/src/main/java/org/nuiton/wikitty/services/WikittyExtensionMigration.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.services;

import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.Wikitty;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.wikitty.WikittyService;

/**
 * Interface used to migrate Wikitty data from one WikittyExtension version
 * to another version
 * 
 * Your implementation can have constructor with ApplicationConfig as argument.
 * 
 * @author poussin
 * @version $Revision: 1300 $
 *
 * Last update: $Date: 2012-01-07 21:40:21 +0100 (Sat, 07 Jan 2012) $
 * by : $Author: bpoussin $
 */
public interface WikittyExtensionMigration {

    // TODO poussin 20090902 permit configuration of migrationRegistry
    /**
     * use to put migration class for extension.
     * key: extensionName, value: migration class
     * @deprecated use new {@link WikittyExtensionMigrationRegistry}
     */
    @Deprecated
    static public Map<String, WikittyExtensionMigration> migrationRegistry =
            new HashMap<String, WikittyExtensionMigration>();

    /**
     * Migrate wikitty data from oldExt version to newExt.
     * 
     * @param service Wikitty service that do migration
     * @param wikitty Wikitty object that contains data in old version
     * extension format
     * @param oldExt old extension definition
     * @param newExt new extension definition
     * @return same wikitty as argument if nothing to do, or new wikitty
     * if some modification is done
     */
    public Wikitty migrate(WikittyService service, Wikitty wikitty,
            WikittyExtension oldExt, WikittyExtension newExt);

}
