/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyUserAbstract extends BusinessEntityImpl implements WikittyUser {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyUser;
    /**
     * getLogin :
     * @return String 
     */

    @Override
    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    @Override
    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * WikittyUserAbstract :
     */

    public WikittyUserAbstract() {
        super();
}

    /**
     * WikittyUserAbstract :
     * @param wikitty 
     */

    public WikittyUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyUserAbstract :
     * @param businessEntityImpl 
     */

    public WikittyUserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyUser =
                new WikittyExtension(EXT_WIKITTYUSER,
                                     "1.0", // version
                                     (List)null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String login unique=\"true\"", 
                                             "String password unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyUserAbstract
