/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAccessStatHelper;
import org.nuiton.wikitty.entities.WikittyAccessStatImpl;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.services.WikittyServiceDelegator;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceAccessStat
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceAccessStat.class);
    protected AccessStatStorage statStorage;
    protected Set<String> extensions = new HashSet<String>();

    public WikittyServiceAccessStat(ApplicationConfig config, WikittyService service, AccessStatStorage statStorage) {
        super(service);
        this.statStorage = statStorage;
        if (statStorage == null) {
            if (log.isWarnEnabled()) {
                String statSto = config.getOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICEACCESSSTAT_COMPONENTS.getKey());
                log.warn((Object)String.format("No AccessStatStorage available, access stat can't work (%s)", statSto));
            }
        } else {
            List exts = config.getOptionAsList(WikittyConfigOption.WIKITTY_ACCESSSTAT_EXTENSIONS.getKey()).getOption();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Monitor access to extensions %s", exts));
            }
            this.extensions.addAll(exts);
        }
    }

    protected String getUserId(String securityToken) {
        String result = null;
        if (securityToken != null) {
            Wikitty securityTokenWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, securityToken);
            if (securityTokenWikitty == null) {
                log.warn((Object)"bad (obsolete ?) token");
            } else {
                result = WikittyTokenHelper.getUser(securityTokenWikitty);
            }
        }
        return result;
    }

    protected boolean isMonitored(Collection<String> exts) {
        String ext;
        boolean result = false;
        Iterator<String> i$ = exts.iterator();
        while (i$.hasNext() && !(result = this.extensions.contains(ext = i$.next()))) {
        }
        return result;
    }

    protected void addStat(String securityToken, Collection wikitties) {
        if (this.statStorage == null) {
            return;
        }
        boolean userLoaded = false;
        String user = null;
        ArrayList<Wikitty> stats = new ArrayList<Wikitty>(wikitties.size());
        for (Object o : wikitties) {
            String id = null;
            Collection<String> exts = null;
            if (o instanceof Wikitty) {
                Wikitty w = (Wikitty)o;
                id = w.getWikittyId();
                exts = w.getExtensionNames();
            } else if (o instanceof BusinessEntity) {
                BusinessEntity e = (BusinessEntity)o;
                id = e.getWikittyId();
                exts = e.getExtensionNames();
            }
            if (exts == null || !this.isMonitored(exts)) continue;
            if (!userLoaded) {
                user = this.getUserId(securityToken);
                userLoaded = true;
            }
            WikittyAccessStatImpl stat = new WikittyAccessStatImpl();
            stat.setDate(new Date());
            stat.setToken(securityToken);
            stat.setUser(user);
            stat.setRestored(id);
            stats.add(stat.getWikitty());
        }
        if (stats.size() > 0) {
            this.statStorage.store(this, securityToken, stats);
        }
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> id) {
        List<Wikitty> result = super.restore(securityToken, id);
        this.addStat(securityToken, result);
        return result;
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty result = super.restoreVersion(securityToken, wikittyId, version);
        this.addStat(securityToken, Collections.singleton(result));
        return result;
    }

    public static class AccessStatStorageLog
    implements AccessStatStorage {
        private static Log log = LogFactory.getLog((String)"AccessStat");

        @Override
        public void store(WikittyServiceAccessStat ws, String securityToken, Collection<Wikitty> stats) {
            for (Wikitty w : stats) {
                Date date = WikittyAccessStatHelper.getDate(w);
                String token = WikittyAccessStatHelper.getToken(w);
                String user = WikittyAccessStatHelper.getUser(w);
                String restored = WikittyAccessStatHelper.getRestored(w);
                log.info((Object)String.format("[%1$tF %1$tT] in session '%2$s' user '%3$s' restore '%4$s'", date, token, user, restored));
            }
        }
    }

    public static class AccessStatStorageWikitty
    implements AccessStatStorage {
        @Override
        public void store(WikittyServiceAccessStat ws, String securityToken, Collection<Wikitty> stats) {
            ws.getDelegate().store(securityToken, stats, false);
        }
    }

    public static interface AccessStatStorage {
        public void store(WikittyServiceAccessStat var1, String var2, Collection<Wikitty> var3);
    }
}

