package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Sun Aug 09 10:50:22 CEST 2015")
public class WikittyTreeNodeHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyTreeNodeHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME, name);
        return oldValue;
}

    public static Set<String> getAttachment(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, String.class);
        return result;
}

    public static void setAttachment(Wikitty wikitty, Set<String> attachment) {
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, attachment);
}

    public static void addAllAttachment(Wikitty wikitty, Collection<String> attachment) {
        if(attachment != null){
            for (String v:attachment){
                addAttachment(wikitty, v);
            }
        }
}

    public static void addAttachment(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, v);
        }
}

    public static void removeAttachment(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, v);
        }
}

    public static void clearAttachment(Wikitty wikitty) {
        wikitty.clearField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
}

    public static Set<Wikitty> getAttachment(Wikitty wikitty, boolean exceptionIfNotLoaded) {
        Set<Wikitty> result = wikitty.getFieldAsWikittySet(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, exceptionIfNotLoaded);
        return result;
}

    public static void setAttachmentEntity(Wikitty wikitty, Collection<Wikitty> attachment) {
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, attachment);
}

    public static void addAllAttachmentEntity(Wikitty wikitty, Collection<Wikitty> attachment) {
        if(attachment != null){
            for (Wikitty v:attachment){
                addAttachment(wikitty, v);
            }
        }
}

    public static void addAttachment(Wikitty wikitty, Wikitty... element) {
        for (Wikitty v : element) {
            wikitty.addToField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, v);
        }
}

    public static void removeAttachment(Wikitty wikitty, Wikitty... element) {
        for (Wikitty v : element) {
            wikitty.removeFromField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, v);
        }
}

    public static String getParent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
        return value;
}

    public static String setParent(Wikitty wikitty, String parent) {
        String oldValue = getParent(wikitty);
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, parent);
        return oldValue;
}

    public static WikittyTreeNode getParent(Wikitty wikitty, boolean exceptionIfNotLoaded) {
        WikittyTreeNode value = WikittyUtil.newInstance(WikittyTreeNode.class, wikitty.getFieldAsWikitty(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, exceptionIfNotLoaded));
        return value;
}

    public static WikittyTreeNode setParent(Wikitty wikitty, WikittyTreeNode parent) {
        WikittyTreeNode oldValue = getParent(wikitty, false);
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, parent);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyTreeNode.EXT_WIKITTYTREENODE);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTreeNodeAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTreeNodeAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyTreeNode.EXT_WIKITTYTREENODE);
}

} //WikittyTreeNodeHelper
