/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.UUID;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.services.WikittyServiceAuthenticationAbstract;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceAuthenticationLDAP
extends WikittyServiceAuthenticationAbstract {
    private static Log log = LogFactory.getLog(WikittyServiceAuthenticationLDAP.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceAuthenticationLDAP.class);
    protected Properties jndiProp;
    protected String ldapLoginPattern;

    public WikittyServiceAuthenticationLDAP(ApplicationConfig config, WikittyService ws) {
        super(config, ws);
        long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_INFO.getKey());
        long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_WARN.getKey());
        timeLog.setTimeToLogInfo(timeToLogInfo);
        timeLog.setTimeToLogWarn(timeToLogWarn);
        Properties jndiPropTmp = config.getOptionStartsWith(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_JNDI.getKey());
        this.jndiProp = new Properties();
        Enumeration<?> e = jndiPropTmp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = jndiPropTmp.getProperty(key);
            int debut = WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_JNDI.getKey().length();
            key = key.substring(debut);
            this.jndiProp.setProperty(key, value);
        }
        String serverUrl = config.getOption(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_SERVER.getKey());
        this.jndiProp.put("java.naming.provider.url", serverUrl);
        this.ldapLoginPattern = config.getOption(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_LOGIN_PATTERN.getKey());
    }

    protected boolean canCreateUser() {
        boolean result = this.config.getOptionAsBoolean(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_AUTOCREATE_USER.getKey());
        return result;
    }

    @Override
    public String login(String login, String password) {
        long start = TimeLog.getTime();
        Wikitty user = null;
        WikittyQuery criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyUser.login", (Object)login)).end();
        String userId = this.getAnonymousClient().findByQuery(criteria);
        boolean authenticated = false;
        if (this.canCreateUser() || userId != null) {
            String ldapLogin = String.format(this.ldapLoginPattern, login);
            Hashtable<Object, Object> env = new Hashtable<Object, Object>(this.jndiProp);
            env.put("java.naming.security.principal", ldapLogin);
            env.put("java.naming.security.credentials", password);
            try {
                InitialDirContext dirContext = new InitialDirContext(env);
                dirContext.close();
                authenticated = true;
            }
            catch (NamingException eee) {
                log.debug((Object)String.format("Erreur lors de l'acces au serveur LDAP pour l'utilisateur %s -> %s", login, ldapLogin), (Throwable)eee);
            }
            if (authenticated) {
                log.info((Object)String.format("External authentication success for account '%s'", login));
                if (userId == null) {
                    user = new WikittyImpl();
                    WikittyUserHelper.addExtension(user);
                    WikittyUserHelper.setLogin(user, login);
                    String generatedPassword = "external-" + UUID.randomUUID();
                    WikittyUserHelper.setPassword(user, generatedPassword);
                    this.getDelegate().store(null, Collections.singletonList(user), false);
                    log.info((Object)String.format("Automatic user creation for account '%s'", login));
                } else {
                    user = WikittyServiceEnhanced.restore(this.getDelegate(), null, userId);
                }
            }
        }
        if (!authenticated) {
            throw new SecurityException("bad login or password");
        }
        String tokenId = this.getToken(user);
        timeLog.log(start, "login");
        return tokenId;
    }
}

