/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyExtensionMigration;

public class WikittyExtensionMigrationRename
implements WikittyExtensionMigration {
    private static Log log = LogFactory.getLog(WikittyExtensionMigrationRename.class);
    public static final String TAG_RENAME = "renameFrom";

    @Override
    public Wikitty migrate(WikittyService service, Wikitty oldWikitty, Wikitty newWikitty, WikittyExtension oldExt, WikittyExtension newExt) {
        String extName = newExt.getName();
        Collection<String> oldFieldNames = oldExt.getFieldNames();
        Collection<String> newFieldNames = newExt.getFieldNames();
        for (String fieldName : newFieldNames) {
            Object value;
            FieldType fieldType = newExt.getFieldType(fieldName);
            String renameFrom = fieldType.getTagValue(TAG_RENAME);
            log.debug((Object)("Scan rename migration on " + extName + "." + fieldName + ":" + TAG_RENAME + "=" + renameFrom));
            if (StringUtils.isNotBlank((CharSequence)renameFrom)) {
                value = oldWikitty.getFieldAsObject(extName, renameFrom);
                log.debug((Object)("Rename " + extName + "." + fieldName + "=" + value));
                newWikitty.setField(extName, fieldName, value);
                continue;
            }
            if (!oldFieldNames.contains(fieldName)) continue;
            value = oldWikitty.getFieldAsObject(extName, fieldName);
            log.debug((Object)("Copy " + extName + "." + fieldName + "=" + value));
            newWikitty.setField(extName, fieldName, value);
        }
        return newWikitty;
    }
}

