/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.search.operators.And;
import org.nuiton.wikitty.search.operators.AssociatedRestriction;
import org.nuiton.wikitty.search.operators.Between;
import org.nuiton.wikitty.search.operators.BinaryOperator;
import org.nuiton.wikitty.search.operators.Contains;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.False;
import org.nuiton.wikitty.search.operators.In;
import org.nuiton.wikitty.search.operators.Keyword;
import org.nuiton.wikitty.search.operators.Not;
import org.nuiton.wikitty.search.operators.Null;
import org.nuiton.wikitty.search.operators.Or;
import org.nuiton.wikitty.search.operators.Restriction;
import org.nuiton.wikitty.search.operators.RestrictionName;
import org.nuiton.wikitty.search.operators.True;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittySearchEngineInMemory
implements WikittySearchEngine {
    protected WikittyStorageInMemory wikittyStorage;

    public WikittySearchEngineInMemory(WikittyStorageInMemory wikittyStorage) {
        this.wikittyStorage = wikittyStorage;
    }

    @Override
    public void clear(WikittyTransaction transaction) {
    }

    @Override
    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
    }

    @Override
    public void delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
    }

    public boolean checkRestriction(WikittyTransaction transaction, Restriction restriction, Wikitty w) {
        if (restriction instanceof BinaryOperator) {
            BinaryOperator binOp = (BinaryOperator)restriction;
            String fqfieldName = binOp.getElement().getName();
            if (Element.ELT_EXTENSION.equals(fqfieldName)) {
                boolean checked = false;
                switch (restriction.getName()) {
                    case NOT_EQUALS: {
                        checked = !w.getExtensionNames().contains(binOp.getValue());
                        break;
                    }
                    case EQUALS: {
                        checked = w.getExtensionNames().contains(binOp.getValue());
                    }
                }
                return checked;
            }
            if (Element.ELT_ID.equals(fqfieldName)) {
                boolean checked = false;
                switch (restriction.getName()) {
                    case NOT_EQUALS: {
                        checked = !w.getId().equals(binOp.getValue());
                        break;
                    }
                    case EQUALS: {
                        checked = w.getId().equals(binOp.getValue());
                    }
                }
                return checked;
            }
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return RestrictionName.NOT_EQUALS == restriction.getName();
            }
            Object o = w.getFqField(fqfieldName);
            FieldType t = w.getFieldType(fqfieldName);
            Object value = binOp.getValue();
            if (!(value instanceof Collection) && t.isCollection()) {
                value = Collections.singleton(value);
            }
            value = t.getValidValue(value);
            boolean checked = false;
            switch (restriction.getName()) {
                case EQUALS: {
                    if (value instanceof String && o instanceof String) {
                        String pattern = (String)value;
                        pattern = pattern.replace("*", "\\p{ASCII}*");
                        pattern = pattern.replace("?", "\\p{ASCII}");
                        Pattern p = Pattern.compile(pattern);
                        Matcher m = p.matcher((String)o);
                        checked = m.matches();
                        break;
                    }
                    checked = value.equals(o);
                    break;
                }
                case LESS: {
                    checked = ((Comparable)o).compareTo(value) < 0;
                    break;
                }
                case LESS_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) <= 0;
                    break;
                }
                case GREATER: {
                    checked = ((Comparable)o).compareTo(value) > 0;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) >= 0;
                    break;
                }
                case NOT_EQUALS: {
                    checked = !value.equals(o);
                    break;
                }
                case ENDS_WITH: {
                    if (t.getType() != FieldType.TYPE.STRING) {
                        throw new WikittyException("Can't search for contents that 'ends with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).endsWith((String)value);
                    break;
                }
                case STARTS_WITH: {
                    if (t.getType() != FieldType.TYPE.STRING) {
                        throw new WikittyException("Can't search for contents that 'starts with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).startsWith((String)value);
                }
            }
            return checked;
        }
        if (restriction instanceof Null) {
            Null nullRes = (Null)restriction;
            String fqfieldName = nullRes.getFieldName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            if (fqfieldName.equals(Element.ELT_EXTENSION)) {
                return false;
            }
            if (fqfieldName.equals(Element.ELT_ID)) {
                return false;
            }
            boolean checked = false;
            switch (nullRes.getName()) {
                case IS_NULL: {
                    checked = o == null;
                    break;
                }
                case IS_NOT_NULL: {
                    checked = o != null;
                }
            }
            return checked;
        }
        if (restriction instanceof In) {
            In in = (In)restriction;
            String fqfieldName = in.getElement().getName();
            String testedValue = String.valueOf(w.getFqField(fqfieldName));
            for (String value : in.getValue()) {
                if (!testedValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof True) {
            return true;
        }
        if (restriction instanceof False) {
            return false;
        }
        if (restriction instanceof Contains) {
            String fieldName;
            Contains contains = (Contains)restriction;
            String fqfieldName = contains.getElement().getName();
            List<String> values = contains.getValue();
            String extension = WikittyUtil.getExtensionNameFromFQFieldName(fqfieldName);
            if (!w.hasField(extension, fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqfieldName))) {
                return false;
            }
            String testedValuesAsString = w.getFieldAsString(extension, fieldName);
            if ('[' == testedValuesAsString.charAt(0)) {
                testedValuesAsString = testedValuesAsString.substring(1, testedValuesAsString.length());
            }
            List<String> testedValues = Arrays.asList(testedValuesAsString.split(","));
            for (String value : values) {
                if (testedValues.contains(String.valueOf(value))) continue;
                return false;
            }
            return true;
        }
        if (restriction instanceof And) {
            And and = (And)restriction;
            for (Restriction sub : and.getRestrictions()) {
                if (this.checkRestriction(transaction, sub, w)) continue;
                return false;
            }
            return true;
        }
        if (restriction instanceof Or) {
            Or or = (Or)restriction;
            for (Restriction sub : or.getRestrictions()) {
                if (!this.checkRestriction(transaction, sub, w)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof Keyword) {
            Keyword keyword = (Keyword)restriction;
            String value = keyword.getValue();
            for (String fieldName : w.getAllFieldNames()) {
                String testedValue = String.valueOf(w.getFqField(fieldName));
                if (!testedValue.contains(value)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof Not) {
            Not or = (Not)restriction;
            Restriction sub = or.getRestriction();
            return !this.checkRestriction(transaction, sub, w);
        }
        if (restriction instanceof AssociatedRestriction) {
            AssociatedRestriction ass = (AssociatedRestriction)restriction;
            String fqfieldName = ass.getElement().getName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            Restriction sub = ass.getRestriction();
            Criteria associatedSearch = new Criteria();
            associatedSearch.setRestriction(sub);
            PagedResult<String> associatedResult = this.findAllByCriteria(transaction, associatedSearch);
            List<String> associatedList = associatedResult.getAll();
            return associatedList.contains(String.valueOf(o));
        }
        if (restriction instanceof Between) {
            Between op = (Between)restriction;
            Set<String> max = op.getMax();
            Set<String> min = op.getMin();
            if (op.getElement().getName().equals(Element.ELT_EXTENSION)) {
                return false;
            }
            if (op.getElement().getName().equals(Element.ELT_ID)) {
                return false;
            }
            String fqfieldName = op.getElement().getName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            FieldType t = w.getFieldType(fqfieldName);
            if (!(min instanceof Collection) && t.isCollection()) {
                min = Collections.singleton(min);
            }
            min = t.getValidValue(min);
            if (!(max instanceof Collection) && t.isCollection()) {
                max = Collections.singleton(max);
            }
            max = t.getValidValue(max);
            return ((Comparable)o).compareTo(min) >= 0 && ((Comparable)o).compareTo(max) <= 0;
        }
        throw new UnsupportedOperationException((Object)((Object)restriction.getName()) + " Search Not yet implemented");
    }

    @Override
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        int firstIndex = criteria.getFirstIndex();
        int endIndex = criteria.getEndIndex();
        LinkedList<String> ids = new LinkedList<String>();
        int currentIndex = 0;
        for (Map.Entry<String, Wikitty> entry : this.wikittyStorage.getWikitties().entrySet()) {
            Wikitty w = entry.getValue();
            String id = entry.getKey();
            Restriction dto = criteria.getRestriction();
            if (w.isDeleted() || !this.checkRestriction(transaction, dto, w)) continue;
            if (++currentIndex > firstIndex) {
                ids.add(id);
            }
            if (endIndex < 0 || currentIndex < endIndex) continue;
            break;
        }
        return new PagedResult<String>(firstIndex, ids.size(), criteria.getRestriction().toString(), null, ids);
    }

    @Override
    public TreeNodeResult<String> findAllChildrenCount(WikittyTransaction transaction, String wikittyId, int depth, boolean count, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

