/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNodeResult<T>
extends DefaultMutableTreeNode
implements Iterable<TreeNodeResult<T>> {
    private static Log log = LogFactory.getLog(TreeNodeResult.class);
    private static final long serialVersionUID = 31L;
    protected int attCount;

    public TreeNodeResult(T object, int attCount) {
        super(object);
        this.attCount = attCount;
    }

    public boolean acceptVisitor(Visitor<T> visitor) {
        if (visitor.visitEnter(this)) {
            TreeNodeResult child;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && (child = (TreeNodeResult)e.nextElement()).acceptVisitor(visitor)) {
            }
        }
        boolean result = visitor.visitLeave(this);
        return result;
    }

    public List<TreeNodeResult<T>> getChildren() {
        List<TreeNodeResult<Object>> result = this.children == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(this.children));
        return result;
    }

    @Override
    public Iterator<TreeNodeResult<T>> iterator() {
        Iterator result = new Iterator<TreeNodeResult<T>>(){
            protected Enumeration enumDepth;
            {
                this.enumDepth = TreeNodeResult.this.depthFirstEnumeration();
            }

            @Override
            public boolean hasNext() {
                return this.enumDepth.hasMoreElements();
            }

            @Override
            public TreeNodeResult<T> next() {
                TreeNodeResult result = (TreeNodeResult)this.enumDepth.nextElement();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        return result;
    }

    public T getObject() {
        return (T)this.getUserObject();
    }

    public TreeNodeResult<T> getChild(T child) {
        TreeNodeResult result = null;
        if (child != null) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                TreeNodeResult r = (TreeNodeResult)e.nextElement();
                if (!child.equals(r.getObject())) continue;
                result = r;
                break;
            }
        }
        return result;
    }

    public int getAttCount() {
        return this.attCount;
    }

    public static interface Visitor<T> {
        public boolean visitEnter(TreeNodeResult<T> var1);

        public boolean visitLeave(TreeNodeResult<T> var1);
    }
}

