package org.nuiton.wikitty.search;

import java.io.Serializable;
import java.util.List;

/**
 * Contains operator is used to build restriction containing "(element like
 * *value1 or element like value1*) and (element like *value2 or element like
 * value2*)" where element could be a String, a multimedia, a text or an xhtml
 * <br>
 * <br>
 * For example, use:
 * <ul>
 * <li>RestrictionHelper.contains( myElement , "value1" )</li>
 * <li>RestrictionHelper.contains( myElement , "value1", "value2", ... )</li>
 * <li>RestrictionHelper.contains( myElement ,
 * a_list_containing_at_least_one_string )</li>
 * </ul>
 */
public class Contains extends Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected Element element;
    protected List<String> value;

    /**
     * Default constructor
     */
    public Contains() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param element
     * @param value
     */
    public Contains(Element element, List<String> value) {
        this.element = element;
        this.value = value;
    }

    /**
     * Return element
     * 
     * @return
     */
    public Element getElement() {
        return element;
    }

    /**
     * Set a value to parameter element.
     * 
     * @param element
     */
    public void setElement(Element element) {
        this.element = element;
    }

    /**
     * Return value
     * 
     * @return
     */
    public List<String> getValue() {
        return value;
    }

    /**
     * Set a value to parameter value.
     * 
     * @param value
     */
    public void setValue(List<String> value) {
        this.value = value;
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Contains)) {
            return false;
        }

        final Contains contains = (Contains) other;

        if ((element == null && contains.getElement() != null)
                || (element != null && !element.equals(contains.getElement())))
            return false;
        if ((value == null && contains.getValue() != null)
                || (value != null && !value.equals(contains.getValue())))
            return false;

        return true;
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return Contains.class.hashCode();
    }

}