/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.api.AbstractTestApi;
import org.nuiton.wikitty.search.And;
import org.nuiton.wikitty.search.AssociatedRestriction;
import org.nuiton.wikitty.search.Between;
import org.nuiton.wikitty.search.BinaryOperator;
import org.nuiton.wikitty.search.Equals;
import org.nuiton.wikitty.search.Or;
import org.nuiton.wikitty.search.Restriction;
import org.nuiton.wikitty.search.RestrictionName;
import org.nuiton.wikitty.search.Search;

public class SearchCriteriaTest
extends AbstractTestApi {
    private static Log log = LogFactory.getLog(SearchCriteriaTest.class);
    String elementName = "ELM_NAME";
    String value = "Value";

    @Test
    public void testBinaryOperators() throws Exception {
        this.checkSearch(SearchCriteriaTest.q().eq(this.elementName, this.value), RestrictionName.EQUALS);
        this.checkSearch(SearchCriteriaTest.q().neq(this.elementName, this.value), RestrictionName.NOT_EQUALS);
        this.checkSearch(SearchCriteriaTest.q().lt(this.elementName, this.value), RestrictionName.LESS);
        this.checkSearch(SearchCriteriaTest.q().le(this.elementName, this.value), RestrictionName.LESS_OR_EQUAL);
        this.checkSearch(SearchCriteriaTest.q().gt(this.elementName, this.value), RestrictionName.GREATER);
        this.checkSearch(SearchCriteriaTest.q().ge(this.elementName, this.value), RestrictionName.GREATER_OR_EQUAL);
        this.checkSearch(SearchCriteriaTest.q().sw(this.elementName, this.value), RestrictionName.STARTS_WITH);
        this.checkSearch(SearchCriteriaTest.q().ew(this.elementName, this.value), RestrictionName.ENDS_WITH);
    }

    @Test
    public void testBetween() throws Exception {
        Criteria criteria = SearchCriteriaTest.q().bw(this.elementName, "from", "to").criteria();
        Restriction restriction = criteria.getRestriction();
        Assert.assertTrue((boolean)(restriction instanceof Between));
        Between between = (Between)restriction;
        Assert.assertEquals((String)"from", (String)between.getMin());
        Assert.assertEquals((String)"to", (String)between.getMax());
    }

    @Test
    public void testAnd() throws Exception {
        Restriction dto = SearchCriteriaTest.q().eq(this.elementName + "0", this.value + "0").gt(this.elementName + "1", this.value + "1").ew(this.elementName + "2", this.value + "2").criteria().getRestriction();
        Assert.assertTrue((boolean)(dto instanceof And));
        And and = (And)dto;
        Restriction[] dtos = and.getRestrictions().toArray(new Restriction[0]);
        this.checkRestriction(dtos[0], RestrictionName.EQUALS, this.elementName + "0", this.value + "0");
        this.checkRestriction(dtos[1], RestrictionName.GREATER, this.elementName + "1", this.value + "1");
        this.checkRestriction(dtos[2], RestrictionName.ENDS_WITH, this.elementName + "2", this.value + "2");
    }

    @Test
    public void testOr() throws Exception {
        String[] elementNames = new String[4];
        String[] values = new String[4];
        for (int i = 0; i < elementNames.length; ++i) {
            elementNames[i] = this.elementName + i;
            values[i] = this.value + i;
        }
        Search q = SearchCriteriaTest.q().eq(elementNames[0], values[0]);
        Search qor = q.or().gt(elementNames[1], values[1]).ew(elementNames[2], values[2]).lt(elementNames[3], values[3]);
        Restriction dto = q.criteria().getRestriction();
        Assert.assertTrue((String)("Restriction is " + dto.getClass().getName()), (boolean)(dto instanceof And));
        And and = (And)dto;
        Restriction[] dtos = and.getRestrictions().toArray(new Restriction[0]);
        this.checkRestriction(dtos[0], RestrictionName.EQUALS, this.elementName + "0", this.value + "0");
        Assert.assertTrue((String)("Restriction is " + dtos[1].getClass().getName()), (boolean)(dtos[1] instanceof Or));
        Or or = (Or)dtos[1];
        dtos = or.getRestrictions().toArray(new Restriction[0]);
        this.checkRestriction(dtos[0], RestrictionName.GREATER, this.elementName + "1", this.value + "1");
        this.checkRestriction(dtos[1], RestrictionName.ENDS_WITH, this.elementName + "2", this.value + "2");
        this.checkRestriction(dtos[2], RestrictionName.LESS, this.elementName + "3", this.value + "3");
    }

    @Test
    public void testAssociated() throws Exception {
        Restriction dto = SearchCriteriaTest.q().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "Hardware").criteria().getRestriction();
        Assert.assertTrue((String)("Restriction is " + dto.getClass().getName()), (boolean)(dto instanceof AssociatedRestriction));
        AssociatedRestriction ass = (AssociatedRestriction)dto;
        Restriction embedded = ass.getRestriction();
        Assert.assertTrue((String)("Restriction is " + dto.getClass().getName()), (boolean)(embedded instanceof Equals));
        this.checkRestriction(embedded, RestrictionName.EQUALS, "Category.name", "Hardware");
        Assert.assertEquals((String)"Product.category", (String)ass.getElement().getName());
        Restriction parentRestriction = ass.getParentRestrictionDto();
        Assert.assertTrue((String)("Restriction is " + dto.getClass().getName()), (boolean)(parentRestriction instanceof And));
        And and = (And)parentRestriction;
        Restriction[] dtos = and.getRestrictions().toArray(new Restriction[0]);
        Assert.assertTrue((boolean)(dtos[0] instanceof Between));
        this.checkRestriction(dtos[1], RestrictionName.STARTS_WITH, "Product.name", "Paint");
    }

    @Test
    public void testXML() throws Exception {
        Criteria criteria = SearchCriteriaTest.q().bw(this.elementName, "from", "to").criteria();
        String xml = Criteria.toXML((Criteria)criteria);
        log.debug((Object)("[XML] " + xml));
        Assert.assertNotNull((Object)xml);
        criteria = Criteria.fromXML((String)xml);
        Assert.assertNotNull((Object)criteria);
    }

    private static final Search q() {
        return Search.query();
    }

    private void checkSearch(Search search, RestrictionName name) throws Exception {
        Restriction dto = search.criteria().getRestriction();
        this.checkRestriction(dto, name, this.elementName, this.value);
    }

    private void checkRestriction(Restriction dto, RestrictionName name, String element, String value) throws Exception {
        Assert.assertTrue((boolean)(dto instanceof BinaryOperator));
        BinaryOperator bop = (BinaryOperator)dto;
        Assert.assertEquals((Object)name, (Object)dto.getName());
        Assert.assertEquals((String)element, (String)bop.getElement().getName());
        Assert.assertEquals((String)value, (String)bop.getValue());
    }
}

