package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class LabelAbstract extends BusinessEntityWikitty implements Label {

    private static final long serialVersionUID = -1282429385L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionLabel =
        new WikittyExtension(EXT_LABEL, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String labels[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionLabel);

        extensions = Collections.unmodifiableList(exts);
    }

	public LabelAbstract() {
		super();
	}

    public LabelAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public LabelAbstract(Wikitty wi) {
		super(wi);
	}

    public Set<String> getLabels() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_LABEL, "labels", String.class);
        return result;
    }

    public void addLabels(String element) {
        getWikitty().addToField(EXT_LABEL, "labels", element);
        getPropertyChangeSupport().firePropertyChange("labels", null, getLabels());
    }
    
    public void removeLabels(String element) {
        getWikitty().removeFromField(EXT_LABEL, "labels", element);
        getPropertyChangeSupport().firePropertyChange("labels", null, getLabels());
    }
    
    public void clearLabels() {
        getWikitty().clearField(EXT_LABEL, "labels");
        getPropertyChangeSupport().firePropertyChange("labels", null, getLabels());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_LABEL, FIELD_LABELS);
            Object f2 = w2.getFieldAsObject(EXT_LABEL, FIELD_LABELS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //LabelAbstract
