/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.topia.templates.TopiaHibernateTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

public class EntityHibernateMappingGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(EntityHibernateMappingGenerator.class);
    private static final String HIBERNATE_ATTRIBUTE_DEFAULT = "default";
    private static final String HIBERNATE_ATTRIBUTE_SQL_TYPE = "sql-type";
    private static final String HIBERNATE_ATTRIBUTE_NAME = "name";
    private Map<String, String[]> columnNamesMap = new HashMap<String, String[]>();
    public static final String HIBERNATE_ATTRIBUTE_LAZY = "lazy";
    public static final String HIBERNATE_ATTRIBUTE_FETCH = "fetch";
    public static final String HIBERNATE_ATTRIBUTE_NOT_NULL = "not-null";
    public static final String HIBERNATE_ATTRIBUTE_SCHEMA = "schema";
    public static final String HIBERNATE_ATTRIBUTE_PROXY = "proxy";
    public static final String HIBERNATE_ATTRIBUTE_INDEX = "index";
    public static final String HIBERNATE_ATTRIBUTE_UNIQUE = "unique";
    public static final String HIBERNATE_ATTRIBUTE_LENGTH = "length";
    public static final String HIBERNATE_ATTRIBUTE_ORDER_BY = "order-by";
    public static final String HIBERNATE_ATTRIBUTE_CASCADE = "cascade";
    public static final String HIBERNATE_ATTRIBUTE_INVERSE = "inverse";
    public static final String HIBERNATE_ATTRIBUTE_TABLE = "table";
    public static final String HIBERNATE_ATTRIBUTE_DISCRIMINATOR_VALUE = "discriminator-value";
    public static final String HIBERNATE_ATTRIBUTE_FOREIGN_KEY = "foreign-key";
    protected TopiaTemplateHelper templateHelper;
    protected final TopiaHibernateTagValues topiaHibernateTagValues = new TopiaHibernateTagValues();

    public String getFilenameForClass(ObjectModelClass clazz) {
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        String DOName = this.templateHelper.getDOType((ObjectModelElement)clazz, (ObjectModel)this.model);
        return DOName.replace('.', File.separatorChar) + ".hbm.xml";
    }

    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
        String proxyTagValue;
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        String persistenceType = this.templateHelper.getPersistenceType((ObjectModelClassifier)input);
        if (!this.templateHelper.isEntity((ObjectModelClassifier)input)) {
            this.templateHelper.getClass();
            if ("hibernate".equals(persistenceType)) {
                return;
            }
        }
        if (this.fileFoundInClassPath(input)) {
            return;
        }
        ObjectModelPackage aPackage = ((ObjectModel)this.model).getPackage((ObjectModelClassifier)input);
        ClassContext classContext = new ClassContext((ObjectModel)this.model, aPackage, input);
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<hibernate-mapping xmlns=\"http://www.hibernate.org/xsd/hibernate-mapping\"\n");
        output.write("                   xsi:schemaLocation=\"http://www.hibernate.org/xsd/hibernate-mapping classpath://org/hibernate/hibernate-mapping-4.0.xsd\"\n");
        output.write("                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        output.write("                   default-access=\"field\" auto-import=\"true\" package=\"" + input.getPackageName() + "\">\n");
        output.write("");
        boolean haveSuper = input.getSuperclasses().size() > 0;
        ArrayList<ObjectModelAttribute> naturalAttributes = new ArrayList<ObjectModelAttribute>();
        ArrayList<ObjectModelAttribute> noneNaturalAttributes = new ArrayList<ObjectModelAttribute>();
        String clazzDOType = this.templateHelper.getDOType((ObjectModelElement)input, (ObjectModel)this.model);
        String tableName = classContext.getTableName();
        String isAbstract = BooleanUtils.toStringTrueFalse((boolean)input.isAbstract());
        String clazzFQN = input.getQualifiedName();
        HashMap<String, String> optionalAttributesMap = new HashMap<String, String>();
        if (classContext.isUseSchema()) {
            this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_SCHEMA, classContext.getSchema());
        }
        if (StringUtils.isEmpty((CharSequence)(proxyTagValue = this.topiaHibernateTagValues.getProxyInterfaceTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model))) || !proxyTagValue.equals("none")) {
            this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_PROXY, clazzFQN);
        }
        String inheritanceStrategy = null;
        if (haveSuper) {
            ObjectModelClass superClass = (ObjectModelClass)input.getSuperclasses().iterator().next();
            String superClassname = superClass.getQualifiedName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("superClass for " + input.getQualifiedName() + " is " + superClassname));
            }
            String superClassDOType = this.templateHelper.getDOType(superClassname, (ObjectModel)this.model);
            inheritanceStrategy = this.templateHelper.getInheritanceStrategy((ObjectModelClassifier)superClass);
            if ("joined-subclass".equals(inheritanceStrategy) || "union-subclass".equals(inheritanceStrategy)) {
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_TABLE, tableName);
            }
            if ("subclass".equals(inheritanceStrategy)) {
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_DISCRIMINATOR_VALUE, clazzDOType);
            }
            String optionalAttributes = this.attributesToString(optionalAttributesMap);
            output.write("    <" + inheritanceStrategy + " name=\"" + clazzDOType + "\" extends=\"" + superClassDOType + "\" abstract=\"" + isAbstract + "\"" + optionalAttributes + ">\n");
            output.write("");
            if ("joined-subclass".equals(inheritanceStrategy)) {
                output.write("        <key column=\"topiaId\" />\n");
                output.write("");
            }
            noneNaturalAttributes.addAll(input.getAttributes());
        } else {
            String optionalAttributes = this.attributesToString(optionalAttributesMap);
            output.write("    <class name=\"" + clazzDOType + "\" table=\"" + tableName + "\" abstract=\"" + isAbstract + "\"" + optionalAttributes + ">\n");
            output.write("        <id name=\"topiaId\" type=\"string\" length=\"255\"/>\n");
            output.write("");
            String currentInheritanceStrategy = this.templateHelper.getInheritanceStrategy((ObjectModelClassifier)input);
            if ("subclass".equals(currentInheritanceStrategy)) {
                output.write("        <discriminator column=\"topiaDiscriminator\" type=\"string\" />\n");
                output.write("");
            }
            for (ObjectModelAttribute attr : input.getAttributes()) {
                if (this.topiaHibernateTagValues.getNaturalIdTagValue(attr)) {
                    naturalAttributes.add(attr);
                    continue;
                }
                noneNaturalAttributes.add(attr);
            }
            if (!naturalAttributes.isEmpty()) {
                String mutableStr;
                boolean mutable = this.topiaHibernateTagValues.getNaturalIdMutableTagValue((ObjectModelClassifier)input);
                String string = mutableStr = mutable ? " mutable=\"true\"" : "";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("natural-id detected for class " + input.getName() + " (" + mutableStr + ") attributes : " + naturalAttributes));
                }
                output.write("        <natural-id" + mutableStr + ">\n");
                output.write("");
                this.generateAttributes(output, classContext, naturalAttributes, "    ");
                output.write("        </natural-id>\n");
                output.write("");
            }
            output.write("        <version name=\"topiaVersion\" type=\"long\"/>\n");
            output.write("        <property name=\"topiaCreateDate\" type=\"timestamp\"/>\n");
            output.write("");
        }
        this.generateAttributes(output, classContext, noneNaturalAttributes, "");
        if (haveSuper) {
            output.write("    </" + inheritanceStrategy + ">\n");
            output.write("");
        } else {
            output.write("    </class>\n");
            output.write("");
        }
        this.generateDatabaseObjects(output, classContext, naturalAttributes);
        this.generateDatabaseObjects(output, classContext, noneNaturalAttributes);
        output.write("</hibernate-mapping>\n");
        output.write("");
    }

    protected void generateDatabaseObjects(Writer output, ClassContext classContext, List<ObjectModelAttribute> attributes) throws IOException {
        for (ObjectModelAttribute attribute : attributes) {
            ObjectModelPackage aPackage;
            boolean indexForeignKeys;
            if (!attribute.isNavigable() || attribute.hasAssociationClass() || !GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute) || GeneratorUtil.isNMultiplicity((int)attribute.getReverseMaxMultiplicity()) || attribute.getClassifier() == null || !this.templateHelper.isEntity(attribute.getClassifier()) || this.templateHelper.isAbstract(attribute.getClassifier()) || !(indexForeignKeys = this.topiaHibernateTagValues.getIndexForeignKeysTagValue(attribute, aPackage = classContext.getPackage(), (ObjectModel)this.model))) continue;
            String schema = classContext.getSchema();
            boolean withSchema = classContext.isUseSchema();
            String tableName = this.templateHelper.getDbName((ObjectModelElement)attribute.getClassifier());
            String propertyName = this.templateHelper.getReverseDbNameOnReverseAttribute(attribute.getReverseAttribute());
            String indexName = "idx";
            if (withSchema) {
                indexName = indexName + '_' + schema;
            }
            indexName = indexName + '_' + tableName + '_' + propertyName;
            indexName = indexName.toLowerCase();
            if (withSchema) {
                tableName = schema + "." + tableName;
            }
            output.write("    <database-object>\n");
            output.write("        <create>CREATE INDEX " + indexName + " ON " + tableName + "(" + propertyName + ")</create>\n");
            output.write("        <drop>DROP INDEX " + indexName + "</drop>\n");
            output.write("    </database-object>\n");
            output.write("");
        }
    }

    protected void generateAttributes(Writer output, ClassContext classContext, List<ObjectModelAttribute> attributes, String prefix) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !this.templateHelper.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (attr.getClassifier() != null && this.templateHelper.isEntity(attr.getClassifier())) {
                    if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                        this.generateHibernateManyToOne(output, classContext, attr, prefix);
                        continue;
                    }
                    this.generateHibernateOneToOne(output, classContext, attr, prefix);
                    continue;
                }
                this.generateHibernateProperty(output, classContext, attr, prefix);
                continue;
            }
            if (attr.getClassifier() != null && this.templateHelper.isEntity(attr.getClassifier())) {
                if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                    this.generateHibernateManyToMany(output, classContext, attr, prefix);
                    continue;
                }
                this.generateHibernateOneToMany(output, classContext, attr, prefix);
                continue;
            }
            this.generateHibernateMany(output, classContext, attr, prefix);
        }
        ObjectModelClass clazz = classContext.getInput();
        ObjectModelPackage aPackage = classContext.getPackage();
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String notNull = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_NOT_NULL, "true");
                String attrName = this.getName(attr, true);
                String attrType = this.getType(aPackage, clazz, attr, true);
                String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, this.topiaHibernateTagValues.getLazyTagValue(attr));
                String attrColumn = this.templateHelper.getDbName((ObjectModelElement)attr);
                String foreignKeyName = "";
                if (classContext.isGenerateForeignKeyNames()) {
                    foreignKeyName = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FOREIGN_KEY, classContext.getForeignKeyName(attrColumn)).trim();
                }
                output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" " + lazy + "column=\"" + attrColumn + "\" " + notNull + "" + foreignKeyName + "/>\n");
                output.write("");
            }
        }
    }

    protected String getName(ObjectModelAttribute attr) {
        return this.getName(attr, false);
    }

    protected String getName(ObjectModelAttribute attr, boolean isAssoc) {
        String result = Introspector.decapitalize(attr.getName());
        if (attr.hasAssociationClass() && !isAssoc) {
            result = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
        }
        return result;
    }

    protected String getType(ClassContext clazzContext, ObjectModelAttribute attr) {
        return this.getType(clazzContext.getPackage(), clazzContext.getInput(), attr, false);
    }

    protected String getType(ObjectModelPackage aPackage, ObjectModelClass clazz, ObjectModelAttribute attr) {
        return this.getType(aPackage, clazz, attr, false);
    }

    protected String getType(ObjectModelPackage aPackage, ObjectModelClass clazz, ObjectModelAttribute attr, boolean isAssoc) {
        if (attr.hasAssociationClass() && !isAssoc) {
            String type = attr.getAssociationClass().getQualifiedName();
            return this.templateHelper.getDOType(type, (ObjectModel)this.model);
        }
        String type = attr.getType();
        String attrType = this.topiaHibernateTagValues.getHibernateAttributeType(attr, (ObjectModelClassifier)clazz, aPackage, (ObjectModel)this.model);
        if (StringUtils.isNotEmpty((CharSequence)attrType)) {
            type = attrType;
        } else {
            attrType = this.topiaHibernateTagValues.getAttributeType(attr, (ObjectModelClassifier)clazz, aPackage, (ObjectModel)this.model);
            if (StringUtils.isNotEmpty((CharSequence)attrType)) {
                type = attrType;
            } else {
                attrType = this.topiaHibernateTagValues.getTypeTagValue(attr);
                if (StringUtils.isNotEmpty((CharSequence)attrType)) {
                    if (log.isWarnEnabled()) {
                        String message = this.topiaHibernateTagValues.getDeprecatedAttributeTagValueMessage(clazz, attr, TopiaHibernateTagValues.Store.type.getName(), TopiaHibernateTagValues.Store.hibernateAttributeType.getName(), attrType);
                        log.warn((Object)message);
                    }
                    type = attrType;
                } else {
                    String modelType = ((ObjectModel)this.model).getTagValue(type);
                    if (StringUtils.isNotEmpty((CharSequence)modelType)) {
                        String message = this.topiaHibernateTagValues.getDeprecatedModelTagValueMessage((ObjectModel)this.model, type, TopiaHibernateTagValues.Store.attributeType.getName() + "." + type, modelType);
                        log.warn((Object)message);
                        int bracketIndex = modelType.indexOf(40);
                        if (bracketIndex != -1) {
                            type = modelType.substring(0, bracketIndex);
                            int bracketEndIndex = modelType.indexOf(41, bracketIndex + 1);
                            String colmunList = bracketEndIndex != -1 ? modelType.substring(bracketIndex + 1, bracketEndIndex) : modelType.substring(bracketIndex);
                            this.columnNamesMap.put(type, colmunList.split(","));
                        } else {
                            type = modelType;
                        }
                    }
                }
            }
        }
        return this.templateHelper.getDOType(type, (ObjectModel)this.model);
    }

    protected void generateHibernateProperty(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean attrIsEnumeration;
        String attrType = this.getType(classContext, attr);
        String accessField = "field";
        String tagValue = this.topiaHibernateTagValues.getAccessTagValue(attr);
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            accessField = tagValue;
        }
        String attrName = attr.getName();
        String declaringElementDBName = this.templateHelper.getDbName(attr.getDeclaringElement());
        String tableName = declaringElementDBName + "_" + attrName;
        boolean bl = attrIsEnumeration = attr.getClassifier() != null && attr.getClassifier().isEnum();
        if (attrType.trim().endsWith("[]")) {
            attrType = attrType.trim().substring(0, attrType.trim().length() - 2);
            HashMap<String, String> optionalAttributesMap = new HashMap<String, String>();
            if (classContext.isUseSchema()) {
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_SCHEMA, classContext.getSchema());
            }
            if (JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr)) {
                String indexName = tableName + "_idx";
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_INDEX, indexName);
            }
            String optionalAttributes = this.attributesToString(optionalAttributesMap);
            output.write("" + prefix + "        <primitive-array name=\"" + attrName + "\" table=\"" + tableName + "\" access=\"" + accessField + "\"" + optionalAttributes + ">\n");
            output.write("" + prefix + "          <key column=\"" + declaringElementDBName + "\"/>\n");
            output.write("" + prefix + "          <list-index column=\"" + attrName + "_idx\"/>\n");
            output.write("" + prefix + "          <element type=\"" + attrType + "\"/>\n");
            output.write("" + prefix + "        </primitive-array>\n");
            output.write("");
        } else {
            boolean noSpecifiedColumn;
            String lengthTagValue;
            String sqlType;
            HashMap<String, String> optionalAttributesMap = new HashMap<String, String>();
            if (JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr)) {
                String indexName = tableName + "_idx";
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_INDEX, indexName);
            }
            if (EugeneCoreTagValues.isUnique((ObjectModelAttribute)attr)) {
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_UNIQUE, "true");
            }
            this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_NOT_NULL, this.topiaHibernateTagValues.getNotNullTagValue(attr));
            output.write("" + prefix + "        <property name=\"" + attrName + "\" access=\"" + accessField + "\"");
            if (!attrIsEnumeration) {
                output.write(" type=\"" + attrType + "\"");
            }
            String[] columnNames = this.columnNamesMap.get(attrType);
            TreeMap<String, String> columnAttributes = new TreeMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)attr.getDefaultValue())) {
                String defaultValue = attr.getDefaultValue().trim();
                columnAttributes.put(HIBERNATE_ATTRIBUTE_DEFAULT, defaultValue);
            }
            if (!StringUtils.isEmpty((CharSequence)(sqlType = this.topiaHibernateTagValues.getSqlTypeTagValue(attr)))) {
                columnAttributes.put(HIBERNATE_ATTRIBUTE_SQL_TYPE, sqlType);
            }
            if (!StringUtils.isEmpty((CharSequence)(lengthTagValue = this.topiaHibernateTagValues.getLengthTagValue(attr)))) {
                this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_LENGTH, lengthTagValue);
            }
            String optionalAttributes = this.attributesToString(optionalAttributesMap);
            boolean bl2 = noSpecifiedColumn = columnNames == null || columnNames.length == 0;
            if (noSpecifiedColumn) {
                String attrColumn = this.templateHelper.getDbName((ObjectModelElement)attr);
                if (columnAttributes.isEmpty()) {
                    output.write(" column=\"" + attrColumn + "\"" + optionalAttributes + "");
                    if (attrIsEnumeration) {
                        output.write(">\n");
                        output.write("" + prefix + "            <type name=\"org.hibernate.type.EnumType\">\n");
                        output.write("" + prefix + "                <param name=\"" + "enumClass" + "\">" + attrType + "</param>");
                        boolean useEnumerationName = this.topiaHibernateTagValues.hasUseEnumerationNameTagValue(attr, (ObjectModelClassifier)classContext.getInput(), classContext.getPackage(), (ObjectModel)this.model);
                        if (useEnumerationName) {
                            String enumSQLType = String.valueOf(12);
                            output.write("\n");
                            output.write("" + prefix + "                <!-- using name instead of ordinal to store enumeration value -->\n");
                            output.write("" + prefix + "                <param name=\"" + "type" + "\">" + enumSQLType + "</param>");
                        }
                        output.write("\n");
                        output.write("" + prefix + "            </type>\n");
                        output.write("" + prefix + "        </property>\n");
                        output.write("");
                    } else {
                        output.write("/>\n");
                        output.write("");
                    }
                } else {
                    columnAttributes.put(HIBERNATE_ATTRIBUTE_NAME, attrColumn);
                    StringBuilder columnAttributesBuilder = new StringBuilder();
                    for (Map.Entry entry : columnAttributes.entrySet()) {
                        String name = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        columnAttributesBuilder.append(this.generateFromTagValue(name, value, null));
                    }
                    String columnAttributesAsString = " " + columnAttributesBuilder.toString().trim();
                    output.write("" + optionalAttributes + ">\n");
                    output.write("" + prefix + "            <column" + columnAttributesAsString + "/>\n");
                    output.write("" + prefix + "        </property>\n");
                    output.write("");
                }
            } else {
                output.write("" + optionalAttributes + ">\n");
                output.write("");
                for (String columnName : columnNames) {
                    columnName = attrName + "_" + columnName.trim();
                    output.write("" + prefix + "            <column name=\"" + columnName + "\"/>\n");
                    output.write("");
                }
                output.write("" + prefix + "        </property>\n");
                output.write("");
            }
        }
    }

    protected void generateHibernateOneToOne(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean unique = GeneratorUtil.isOneMultiplicity((ObjectModelAttribute)attr);
        this.generateHibernateManyToOne(output, classContext, attr, unique, prefix);
    }

    protected void generateHibernateOneToMany(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr);
        boolean isInverse = attr.getReverseAttribute().isNavigable();
        isInverse |= this.templateHelper.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model);
        String attrName = this.getName(attr);
        String attrType = this.getType(classContext, attr);
        String reverseAttrDBName = this.templateHelper.getReverseDbName(attr);
        String orderBy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_ORDER_BY, this.topiaHibernateTagValues.getOrderByTagValue(attr));
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = cascade + "cascade=\"all,delete-orphan\" ";
        }
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, this.topiaHibernateTagValues.getLazyTagValue(attr), "true");
        String fetch = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FETCH, this.topiaHibernateTagValues.getFetchTagValue(attr));
        String collType = this.templateHelper.getNMultiplicityHibernateType(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        String foreignKeyAttribute = "";
        if (classContext.isGenerateForeignKeyNames()) {
            String columnName = this.templateHelper.getDbName((ObjectModelElement)attr);
            foreignKeyAttribute = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FOREIGN_KEY, classContext.getForeignKeyName(columnName)).trim();
        }
        if (needsIndex) {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + lazy + "" + cascade + ">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"" + foreignKeyAttribute + "/>\n");
            output.write("" + prefix + "            <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        } else {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + orderBy + "" + fetch + "" + lazy + "" + cascade + ">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"" + foreignKeyAttribute + "/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        }
    }

    private String generateFromTagValue(String attributeName, String tagValue) {
        return this.generateFromTagValue(attributeName, tagValue, null);
    }

    private String generateFromTagValue(String attributeName, Boolean tagValue) {
        return this.generateFromTagValue(attributeName, tagValue == null ? null : String.valueOf(tagValue), null);
    }

    private String generateFromTagValue(String attributeName, String tagValue, String defaultValue) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            result = result + attributeName + "=\"" + tagValue + "\" ";
        } else if (defaultValue != null) {
            result = result + attributeName + "=\"" + defaultValue + "\" ";
        }
        return result;
    }

    private void generateFromTagValue(Map<String, String> map, String attributeName, String tagValue) {
        this.generateFromTagValue(map, attributeName, tagValue, null);
    }

    private void generateFromTagValue(Map<String, String> map, String attributeName, Boolean tagValue) {
        this.generateFromTagValue(map, attributeName, tagValue == null ? null : String.valueOf(tagValue), null);
    }

    private void generateFromTagValue(Map<String, String> map, String attributeName, String tagValue, String defaultValue) {
        String value = null;
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            value = tagValue;
        } else if (defaultValue != null) {
            value = defaultValue;
        }
        if (value != null) {
            map.put(attributeName, "\"" + value + "\"");
        }
    }

    private String attributesToString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(" ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    protected void generateHibernateMany(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr);
        String attrName = this.getName(attr);
        String attrType = this.getType(classContext, attr);
        String collType = this.templateHelper.getNMultiplicityHibernateType(attr);
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, this.topiaHibernateTagValues.getLazyTagValue(attr));
        String attrColumn = this.templateHelper.getDbName((ObjectModelElement)attr);
        String foreignKeyAttribute = "";
        String tableName = this.templateHelper.getManyToManyTableName(attr);
        if (classContext.isGenerateForeignKeyNames()) {
            foreignKeyAttribute = " foreign-key=\"" + classContext.getTableName() + "_" + attrColumn + "\"";
        }
        boolean attrIsEnumeration = attr.getClassifier() != null && attr.getClassifier().isEnum();
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" table=\"" + tableName + "\" " + lazy + ">\n");
        output.write("" + prefix + "            <key column=\"OWNER\"/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "            <list-index/>\n");
            output.write("");
        }
        if (attrIsEnumeration) {
            boolean useEnumerationName = this.topiaHibernateTagValues.hasUseEnumerationNameTagValue(attr, (ObjectModelClassifier)classContext.getInput(), classContext.getPackage(), (ObjectModel)this.model);
            output.write("" + prefix + "            <element column=\"" + attrColumn + "\">\n");
            output.write("" + prefix + "                <type name=\"org.hibernate.type.EnumType\">\n");
            output.write("" + prefix + "                    <param name=\"" + "enumClass" + "\">" + attrType + "</param>\n");
            output.write("");
            if (useEnumerationName) {
                String enumSQLType = String.valueOf(12);
                output.write("" + prefix + "                    <!-- using name instead of ordinal to store enumeration value -->\n");
                output.write("" + prefix + "                    <param name=\"" + "type" + "\">" + enumSQLType + "</param>\n");
                output.write("");
            }
            output.write("" + prefix + "                </type>\n");
            output.write("" + prefix + "            </element>\n");
            output.write("");
        } else {
            output.write("" + prefix + "            <element type=\"" + attrType + "\" column=\"" + attrColumn + "\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }

    protected void generateHibernateManyToOne(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        this.generateHibernateManyToOne(output, classContext, attr, false, prefix);
    }

    protected void generateHibernateManyToOne(Writer output, ClassContext classContext, ObjectModelAttribute attr, boolean isUnique, String prefix) throws IOException {
        String attrName = this.getName(attr);
        String attrType = this.getType(classContext, attr);
        String attrColumn = this.templateHelper.getDbName((ObjectModelElement)attr);
        output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" column=\"" + attrColumn + "\" ");
        if (attr.isComposite() || attr.hasAssociationClass()) {
            output.write("cascade=\"delete\" ");
        }
        if (classContext.isGenerateForeignKeyNames()) {
            String foreignKeyName = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FOREIGN_KEY, classContext.getForeignKeyName(attrColumn));
            output.write("" + foreignKeyName + "");
        }
        if (attr.getReverseAttribute() != null && this.templateHelper.hasUnidirectionalRelationOnAbstractType(attr.getReverseAttribute(), (ObjectModel)this.model)) {
            output.write("access=\"field\" ");
        }
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, this.topiaHibernateTagValues.getLazyTagValue(attr));
        output.write("" + lazy + "");
        String notNull = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_NOT_NULL, this.topiaHibernateTagValues.getNotNullTagValue(attr));
        output.write("" + notNull + "");
        if (isUnique) {
            output.write("unique=\"true\" ");
        }
        output.write("/>\n");
        output.write("");
    }

    protected void generateHibernateManyToMany(Writer output, ClassContext classContext, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean isInverse = attr.isNavigable() && attr.getReverseAttribute().isNavigable();
        String inverseValue = this.topiaHibernateTagValues.getInverseTagValue(attr);
        isInverse = StringUtils.isNotEmpty((CharSequence)inverseValue) ? (isInverse &= Boolean.parseBoolean(inverseValue)) : (isInverse &= GeneratorUtil.isFirstAttribute((ObjectModelAttribute)attr));
        boolean needsIndex = JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr);
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = " cascade=\"delete,delete-orphan\"";
        }
        String attrType = this.getType(classContext, attr);
        String attrName = this.getName(attr);
        String attrColumn = this.templateHelper.getDbName((ObjectModelElement)attr);
        String lazy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_LAZY, this.topiaHibernateTagValues.getLazyTagValue(attr), "true");
        String orderBy = this.generateFromTagValue(HIBERNATE_ATTRIBUTE_ORDER_BY, this.topiaHibernateTagValues.getOrderByTagValue(attr));
        String collType = this.templateHelper.getNMultiplicityHibernateType(attr);
        String tableName = this.templateHelper.getManyToManyTableName(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        String reverseAttrDBName = this.templateHelper.getReverseDbName(attr);
        HashMap<String, String> optionalAttributesMap = new HashMap<String, String>();
        if (classContext.isUseSchema()) {
            this.generateFromTagValue(optionalAttributesMap, HIBERNATE_ATTRIBUTE_SCHEMA, classContext.getSchema());
        }
        String optionalAttributes = this.attributesToString(optionalAttributesMap);
        String foreignKeyName = "";
        String reverseForeignKeyName = "";
        if (classContext.isGenerateForeignKeyNames()) {
            foreignKeyName = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FOREIGN_KEY, classContext.getForeignKeyName(tableName, reverseAttrDBName)).trim();
            reverseForeignKeyName = " " + this.generateFromTagValue(HIBERNATE_ATTRIBUTE_FOREIGN_KEY, classContext.getForeignKeyName(tableName, attrColumn)).trim();
        }
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" table=\"" + tableName + "\" " + inverse + "" + lazy + "" + cascade + "" + optionalAttributes + ">\n");
        output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"" + foreignKeyName + "/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "            <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <many-to-many class=\"" + attrType + "\" column=\"" + attrColumn + "\" " + orderBy + "" + reverseForeignKeyName + "/>\n");
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }

    protected boolean fileFoundInClassPath(ObjectModelClass input) {
        String fqn = this.templateHelper.getDOType((ObjectModelElement)input, (ObjectModel)this.model);
        return this.getResourcesHelper().isFullyQualifiedNameInClassPath(fqn, ".hbm.xml");
    }

    class ClassContext {
        private final ObjectModel model;
        private final ObjectModelClass input;
        private final boolean generateForeignKeyNames;
        private final String tableName;
        private final String schema;
        private ObjectModelPackage aPackage;

        ClassContext(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClass input) {
            this.model = model;
            this.input = input;
            this.aPackage = aPackage;
            this.generateForeignKeyNames = EntityHibernateMappingGenerator.this.topiaHibernateTagValues.isGenerateForeignKeyNames((ObjectModelClassifier)input, model);
            this.tableName = EntityHibernateMappingGenerator.this.templateHelper.getDbName((ObjectModelElement)input);
            this.schema = EntityHibernateMappingGenerator.this.topiaHibernateTagValues.getDbSchemaNameTagValue((ObjectModelClassifier)input, aPackage, model);
        }

        public boolean isGenerateForeignKeyNames() {
            return this.generateForeignKeyNames;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isUseSchema() {
            return this.schema != null;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getForeignKeyName(String attrColumn) {
            return this.getForeignKeyName(this.tableName, attrColumn).toLowerCase();
        }

        public String getForeignKeyName(String tableName, String attrColumn) {
            return ("fk_" + tableName + "_" + attrColumn).toLowerCase();
        }

        public ObjectModelClass getInput() {
            return this.input;
        }

        public ObjectModelPackage getPackage() {
            return this.aPackage;
        }
    }
}

