/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.templates.TopiaCoreTagValues;
import org.nuiton.topia.templates.TopiaHibernateTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

public class EntityDaoTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityDaoTransformer.class);
    protected Map<ObjectModelClass, Set<ObjectModelClass>> usages;
    protected Set<String> allEntitiesFqn;
    protected String entityEnumName;
    protected String entityEnumPackage;
    protected TopiaTemplateHelper templateHelper;
    protected final TopiaCoreTagValues topiaCoreTagValues = new TopiaCoreTagValues();
    protected final TopiaHibernateTagValues topiaHibernateTagValues = new TopiaHibernateTagValues();

    public void transformFromModel(ObjectModel model) {
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper(model);
        }
        String modelName = model.getName();
        this.entityEnumName = modelName + "EntityEnum";
        String packageName = this.getDefaultPackageName();
        this.entityEnumPackage = packageName + "." + this.entityEnumName;
        this.usages = this.templateHelper.searchDirectUsages(model);
        this.generateParentDao();
        List<ObjectModelClass> allEntities = this.templateHelper.getEntityClasses(model, true);
        this.allEntitiesFqn = new HashSet<String>(allEntities.size());
        for (ObjectModelClass entity : allEntities) {
            String fqn = entity.getQualifiedName();
            this.allEntitiesFqn.add(fqn);
        }
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!this.templateHelper.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        if (this.isGenerateGeneratedDao(clazz)) {
            this.generateGeneratedDao(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateAbstractDao(clazz)) {
            this.generateAbstractDao(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateConcreteDao(clazz)) {
            this.generateConcreteDao(clazz, clazzName, clazzFQN);
        }
    }

    protected boolean isGenerateConcreteDao(ObjectModelClass input) {
        String daoConcreteFqn = this.templateHelper.getConcreteDaoFqn(input);
        return !this.getResourcesHelper().isJavaFileInClassPath(daoConcreteFqn);
    }

    protected boolean isGenerateGeneratedDao(ObjectModelClass input) {
        String daoGeneratedFqn = this.templateHelper.getGeneratedDaoFqn(input);
        return !this.getResourcesHelper().isJavaFileInClassPath(daoGeneratedFqn);
    }

    protected boolean isGenerateAbstractDao(ObjectModelClass input) {
        String fqn = this.templateHelper.getAbstractDaoFqn(input);
        return !this.getResourcesHelper().isJavaFileInClassPath(fqn);
    }

    protected void generateConcreteDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        String concreteDaoName = this.templateHelper.getConcreteDaoName(clazz);
        ObjectModelClass daoClass = this.createClass(concreteDaoName, clazz.getPackageName());
        this.setDocumentation((ObjectModelElement)daoClass, "/**\n * Cette classe etend le DAOImpl pour parametrer la classe avec le bon type\n * Cette classe est marque finale car l'heritage entre les DAO se fait\n * sur les DOAImpl, c-a-d que DAOAbstract peut etendre le DAOImpl\n */");
        String superclassQualifiedName = this.templateHelper.getAbstractDaoFqn(clazz) + "<" + clazzName + ">";
        this.setSuperClass(daoClass, superclassQualifiedName);
        String legacyConcreteDaoName = TopiaTemplateHelper.getLegacyDaoName(clazz);
        this.warnOnLegacyClassDetected(clazz.getPackageName(), legacyConcreteDaoName, concreteDaoName, null, this.templateHelper.getAbstractDaoFqn(clazz) + "<" + clazzName + ">");
    }

    protected void generateAbstractDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        String abstractDaoName = this.templateHelper.getAbstractDaoName(clazz);
        String daoGenerics = "<E extends " + clazzName + ">";
        ObjectModelClass abstractDaoClass = this.createClass(abstractDaoName + daoGenerics, clazz.getPackageName());
        String documentation = String.format("/**%n * Implantation du Dao pour l'entit\u00e9 '%s'.%n * L'utilisateur peut remplacer cette classe par la sienne en la mettant%n * simplement dans ses sources. Cette classe g\u00e9n\u00e9r\u00e9e sera alors simplement%n * ignor\u00e9e \u00e0 la g\u00e9n\u00e9ration suivante.%n */", clazzName);
        this.setDocumentation((ObjectModelElement)abstractDaoClass, documentation);
        String superclassQualifiedName = this.templateHelper.getGeneratedDaoFqn(clazz) + "<E>";
        this.setSuperClass(abstractDaoClass, superclassQualifiedName);
        String legacyDaoImplName = TopiaTemplateHelper.getLegacyDaoName(clazz) + "Impl";
        this.warnOnLegacyClassDetected(clazz.getPackageName(), legacyDaoImplName, abstractDaoName, daoGenerics, superclassQualifiedName);
    }

    protected void warnOnLegacyClassDetected(String packageName, String legacyDaoName, String daoName, String daoGenerics, String superclassQualifiedName) {
        String legacyDaoFqn = String.format("%s.%s", packageName, legacyDaoName);
        if (log.isWarnEnabled() && this.getFileInClassPath(legacyDaoFqn) != null) {
            String format = "public class %s%s extends %s {";
            String superclassName = superclassQualifiedName.substring(superclassQualifiedName.lastIndexOf(46) + 1);
            String daoDeclaration = String.format(format, daoName, Strings.nullToEmpty((String)daoGenerics), superclassName);
            String warnMessage = "Legacy DAO detected : %s !%n - You should consider renaming '%s' to '%s'%n - Expected class declaration is : %s%n%n";
            log.warn((Object)String.format(warnMessage, legacyDaoFqn, legacyDaoName, daoName, daoDeclaration));
        }
    }

    protected void generateParentDao() {
        String parentDaoFqn = this.templateHelper.getParentDaoFqn(this, (ObjectModel)this.model);
        if (!this.getResourcesHelper().isJavaFileInClassPath(parentDaoFqn)) {
            ObjectModelClass parentDao = this.createAbstractClass(this.templateHelper.getParentDaoName((ObjectModel)this.model) + "<E extends " + TopiaEntity.class.getSimpleName() + ">", this.templateHelper.getDaoPackage(this, (ObjectModel)this.model));
            this.addImport((ObjectModelClassifier)parentDao, TopiaEntity.class);
            this.setSuperClass(parentDao, AbstractTopiaDao.class.getName() + "<E>");
        }
    }

    protected void generateGeneratedDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        ObjectModelClass daoAbstractClass = this.createAbstractClass(this.templateHelper.getGeneratedDaoName(clazz) + "<E extends " + clazzName + '>', clazz.getPackageName());
        String superClassName = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!this.templateHelper.isEntity((ObjectModelClassifier)parent)) continue;
            superClassName = this.templateHelper.getAbstractDaoFqn(parent) + "<E>";
            break;
        }
        if (superClassName == null) {
            superClassName = this.topiaCoreTagValues.getDaoSuperClassTagValue((ObjectModelClassifier)clazz, this.getPackage((ObjectModelClassifier)clazz), (ObjectModel)this.model);
            if (superClassName == null) {
                superClassName = this.templateHelper.getParentDaoFqn(this, (ObjectModel)this.model);
                this.addImport((ObjectModelClassifier)daoAbstractClass, superClassName);
            }
            superClassName = superClassName + "<E>";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("super class = " + superClassName));
        }
        this.setSuperClass(daoAbstractClass, superClassName);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz);
        this.setConstantPrefix(prefix);
        this.addImport((ObjectModelClassifier)daoAbstractClass, List.class);
        this.addImport((ObjectModelClassifier)daoAbstractClass, TopiaQueryBuilderAddCriteriaOrRunQueryStep.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getEntityClass", "Class<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return (Class<E>) " + clazzName + ".class;\n    ");
        this.addImport((ObjectModelClassifier)daoAbstractClass, this.entityEnumPackage);
        op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getTopiaEntityEnum", this.entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return " + this.entityEnumName + "." + clazzName + ";\n    ");
        this.generateDelete(clazz, daoAbstractClass);
        this.generateNaturalId(daoAbstractClass, clazz);
        this.generateNotNull(daoAbstractClass, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, false);
                continue;
            }
            this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, true);
                    continue;
                }
                this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
            }
        }
        Set<ObjectModelClass> usagesForclass = this.usages.get(clazz);
        this.generateFindUsages(clazz, daoAbstractClass, usagesForclass);
        this.generateAggregateOperation(daoAbstractClass, clazz);
        this.generateCompositeOperation(daoAbstractClass, clazz);
    }

    protected void generateDelete(ObjectModelClass clazz, ObjectModelClass result) {
        StringBuilder body = new StringBuilder();
        String modelName = StringUtils.capitalize((String)((ObjectModel)this.model).getName());
        String providerFQN = this.getDefaultPackageName() + '.' + modelName + "DAOHelper.getImplementationClass";
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)clazz);
        body.append("\n        if ( ! entity.isPersisted()) {\n            throw new IllegalArgumentException(\"entity \" + entity  + \" is not persisted, you can't delete it\");\n        }\n");
        boolean hibernateSupportGenerated = false;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrType = GeneratorUtil.getSimpleName((String)attr.getType());
            String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (attr.hasAssociationClass() || reverse == null || !reverse.isNavigable()) continue;
            if (!this.allEntitiesFqn.contains(attr.getType())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[" + result.getName() + "] Skip attribute [" + attr.getName() + "] with type " + attr.getType()));
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                String attrDBName = this.templateHelper.getDbName((ObjectModelElement)attr);
                String attrClassifierDBName = this.templateHelper.getDbName((ObjectModelElement)attr.getClassifier());
                String attrClassifierDBNameSchemaName = this.topiaHibernateTagValues.getDbSchemaNameTagValue(attr.getClassifier(), this.getPackage(attr.getClassifier()), (ObjectModel)this.model);
                if (attrClassifierDBNameSchemaName != null) {
                    attrClassifierDBName = attrClassifierDBNameSchemaName + "." + attrClassifierDBName;
                }
                String attrJoinTableName = this.templateHelper.getManyToManyTableName(attr);
                if (attrClassifierDBNameSchemaName != null) {
                    attrJoinTableName = attrClassifierDBNameSchemaName + "." + attrJoinTableName;
                }
                String attrReverseDBName = this.templateHelper.getReverseDbName(attr);
                if (!hibernateSupportGenerated) {
                    hibernateSupportGenerated = true;
                    this.addImport((ObjectModelClassifier)result, TopiaHibernateSupport.class);
                    this.addImport((ObjectModelClassifier)result, HibernateTopiaJpaSupport.class);
                    this.addImport((ObjectModelClassifier)result, Session.class);
                    body.append("\n        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();\n        Session hibernateSession = hibernateSupport.getHibernateSession();\n");
                }
                String removeName = this.getJavaBeanMethodName("remove", reverseAttrName);
                body.append("\n        {\n            String sql = \"SELECT main.* \" +\n                    \" FROM " + attrClassifierDBName + " main, " + attrJoinTableName + " secondary \" +\n                    \" WHERE main.topiaId=secondary." + attrDBName + " \" +\n                    \" AND secondary." + attrReverseDBName + "='\" + entity.getTopiaId() + \"'\";\n            List<" + attrType + "> list = hibernateSession\n                    .createSQLQuery(sql)\n                    .addEntity(\"main\", " + this.entityEnumName + "." + attrType + ".getImplementation())\n                    .list();\n\n            for (" + attrType + " item : list) {\n                item." + removeName + "(entity);\n            }\n        }\n");
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) continue;
            this.addImport((ObjectModelClassifier)result, attrType);
            this.addImport((ObjectModelClassifier)result, attr.getType() + "TopiaDao");
            String attrSimpleType = GeneratorUtil.getClassNameFromQualifiedName((String)attrType);
            String attrConcreteDaoClassName = attrSimpleType + "TopiaDao";
            String getName = this.getJavaBeanMethodName("get", reverseAttrName);
            String setName = this.getJavaBeanMethodName("set", reverseAttrName);
            body.append("\n        {\n            " + attrConcreteDaoClassName + " dao = topiaDaoSupplier\n                    .getDao(" + attrSimpleType + ".class, " + attrConcreteDaoClassName + ".class);\n            List<" + attrSimpleType + "> list = dao\n                    .forProperties(" + attrSimpleType + "." + this.getConstantName(reverseAttrName) + ", entity)\n                    .findAll();\n            for (" + attrSimpleType + " item : list) {\n\n                // sletellier : Set null only if target is concerned by deletion\n                if (entity.equals(item." + getName + "())) {\n                    item." + setName + "(null);\n                }\n            ");
            if (attr.isAggregate()) {
                body.append("\n            topiaDaoSupplier.getDao(" + attrSimpleType + ".class).delete(item);\n");
            }
            body.append("\n            }\n        }\n");
        }
        if (body.length() > 0) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Override.class);
            this.addParameter(op, "E", "entity");
            body.append("\n        super.delete(entity);\n    ");
            this.setOperationBody(op, body.toString());
        }
    }

    protected void generateFindUsages(ObjectModelClass clazz, ObjectModelClass result, Set<ObjectModelClass> usagesForclass) {
        this.builder.addImport((ObjectModelClassifier)result, LinkedList.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, Map.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, HashMap.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, TopiaEntity.class.getName());
        if (clazz instanceof ObjectModelAssociationClass || usagesForclass.isEmpty()) {
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Class<U>", "type");
            this.addParameter(operation, "E", "entity");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
            this.setOperationBody(operation, "\n        return new LinkedList<U>();\n    ");
            operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "E", "entity");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
            this.setOperationBody(operation, "\n        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();\n    ");
            return;
        }
        List<ObjectModelClass> allEntities = this.templateHelper.getEntityClasses((ObjectModel)this.model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        for (ObjectModelClass klass : allEntities) {
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "Class<U>", "type");
        this.addParameter(operation, "E", "entity");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("\n        List<?> result = new LinkedList();\n        List tmp;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String usageType = usageClass.getQualifiedName();
            this.builder.addImport((ObjectModelClassifier)result, usageType);
            this.builder.addImport((ObjectModelClassifier)result, this.templateHelper.getConcreteDaoFqn(usageClass));
            String usageSimpleType = GeneratorUtil.getClassNameFromQualifiedName((String)usageType);
            String usageSimplePropertyMethod = "findAllBy" + usageSimpleType;
            String usageCollectionPropertyMethod = "findAllContaining" + usageSimpleType;
            for (ObjectModelAttribute attr : usageClass.getAttributes()) {
                ObjectModelClass targetEntity;
                String type;
                if (!attr.isNavigable()) continue;
                String attrName = attr.getName();
                if (attr.hasAssociationClass() || !allEntitiesByFQN.containsKey(type = attr.getType()) || !(targetEntity = (ObjectModelClass)allEntitiesByFQN.get(type)).equals(clazz)) continue;
                String methodName = GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? this.getJavaBeanMethodName("for", attrName, "Contains") : this.getJavaBeanMethodName("for", attrName, "Equals");
                String daoName = this.templateHelper.getConcreteDaoName(usageClass);
                this.builder.addImport((ObjectModelClassifier)result, usageClass.getPackageName() + '.' + daoName);
                buffer.append("\n        if (type == " + usageSimpleType + ".class) {\n            " + daoName + " dao =\n                topiaDaoSupplier.getDao(" + usageSimpleType + ".class, " + daoName + ".class);\n            tmp = dao." + methodName + "(entity).findAll();\n            result.addAll(tmp);\n        }\n");
            }
        }
        buffer.append("\n        return (List<U>) result;\n    ");
        this.setOperationBody(operation, buffer.toString());
        operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "E", "entity");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
        buffer = new StringBuilder(300);
        buffer.append("\n        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;\n        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(" + usagesForclass.size() + ");\n\n        List<? extends TopiaEntity> list;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String fqn = usageClass.getName();
            buffer.append("\n        list = findUsages(" + fqn + ".class, entity);\n        if (!list.isEmpty()) {\n            result.put(" + fqn + ".class, list);\n        }\n");
        }
        buffer.append("\n        return result;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void generateNoNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr, boolean isAssoc) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = clazzName + "." + this.getConstantName(attrName);
        String attrTypeForGeneric = GeneratorUtil.isPrimitiveType((String)attrType) ? this.templateHelper.getClassForPrimitiveType(attr) : attrType;
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            propertyName = clazzName + '.' + this.getConstantName(assocAttrName) + " + '.' + " + assocClassName + '.' + this.getConstantName(attrName);
        }
        this.addImport((ObjectModelClassifier)result, Collection.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "In"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, "Collection<" + attrTypeForGeneric + ">", "v");
        this.setOperationBody(op, "\n        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(" + propertyName + ", (Collection) v);\n        return result;\n    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "Equals"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(" + propertyName + ", v);\n        return result;\n    ");
        String methodToDelegateName = op.getName();
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAnyOrNull();\n    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAll();\n    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocPropertyConstantName = this.getConstantName(assocAttrName);
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", assocClassName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        E result = forProperties(" + clazzName + "." + assocPropertyConstantName + ", value).findAnyOrNull();\n        return result;\n    ");
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", assocClassName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        List<E> result = forProperties(" + clazzName + "." + assocPropertyConstantName + ", value).findAll();\n        return result;\n    ");
        }
    }

    protected void generateNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            return;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "Contains"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return forContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n    ");
        String methodToDelegateName = op.getName();
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findContains", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAnyOrNull();\n    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllContains", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAll();\n    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
    }

    private void generateNaturalId(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = this.templateHelper.getNaturalIdAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNaturalId for " + props));
            }
            ObjectModelOperation findByNaturalId = this.addOperation((ObjectModelClassifier)result, "findByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)findByNaturalId, Deprecated.class);
            ObjectModelOperation existByNaturalId = this.addOperation((ObjectModelClassifier)result, "existByNaturalId", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)existByNaturalId, Deprecated.class);
            ObjectModelOperation createByNaturalId = this.addOperation((ObjectModelClassifier)result, "createByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addImport((ObjectModelClassifier)result, TopiaQueryBuilderRunQueryWithUniqueResultStep.class);
            ObjectModelOperation forNaturalId = this.addOperation((ObjectModelClassifier)result, "forNaturalId", "TopiaQueryBuilderRunQueryWithUniqueResultStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            LinkedHashSet propertiesAndArguments = Sets.newLinkedHashSet();
            LinkedHashSet argumentsOnly = Sets.newLinkedHashSet();
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                String type = attr.getType();
                this.addParameter(findByNaturalId, type, propName);
                this.addParameter(existByNaturalId, type, propName);
                this.addParameter(createByNaturalId, type, propName);
                this.addParameter(forNaturalId, type, propName);
                String property = clazzName + '.' + this.getConstantName(propName) + ", " + propName;
                propertiesAndArguments.add(property);
                argumentsOnly.add(propName);
            }
            String arguments = StringUtils.join((Iterable)propertiesAndArguments, (String)", ");
            String naturalIdArguments = StringUtils.join((Iterable)argumentsOnly, (String)", ");
            this.setOperationBody(findByNaturalId, "\n        return forNaturalId(" + naturalIdArguments + ").findUnique();\n    ");
            this.setOperationBody(existByNaturalId, "\n        return forNaturalId(" + naturalIdArguments + ").exists();\n    ");
            this.setOperationBody(createByNaturalId, "\n        return create(" + arguments + ");\n    ");
            this.setOperationBody(forNaturalId, "\n        return forProperties(" + arguments + ");\n    ");
        }
    }

    protected void generateNotNull(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = this.templateHelper.getNotNullAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNotNull for " + props));
            }
            ObjectModelOperation createByNotNull = this.addOperation((ObjectModelClassifier)result, "createByNotNull", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            String clazzName = clazz.getName();
            ArrayList createPropertiesList = Lists.newArrayList();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                this.addParameter(createByNotNull, attr.getType(), propName);
                createPropertiesList.add(clazzName + '.' + this.getConstantName(propName));
                createPropertiesList.add(propName);
            }
            String createProperties = Joiner.on((String)", ").join((Iterable)createPropertiesList);
            this.setOperationBody(createByNotNull, "\n        return create(" + createProperties + ");\n    ");
        }
    }

    protected void generateCompositeOperation(ObjectModelClass outputAbstract, ObjectModelClass input) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)outputAbstract, "getComposite", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)operation, Override.class);
        this.addImport((ObjectModelClassifier)outputAbstract, ArrayList.class);
        this.addImport((ObjectModelClassifier)outputAbstract, List.class);
        this.addImport((ObjectModelClassifier)outputAbstract, TopiaDao.class);
        StringBuilder body = new StringBuilder("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.referenceClassifier() || !this.templateHelper.isEntity(attr.getClassifier())) continue;
            if (attr.isComposite() && attr.isNavigable()) {
                String attrName = attr.getName();
                String getterName = this.getJavaBeanMethodName("get", attrName);
                if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("        if (entity." + getterName + "() != null) {\n              tmp.addAll(entity." + getterName + "());\n           }\n");
                    continue;
                }
                body.append("        tmp.add(entity." + getterName + "());\n");
                continue;
            }
            if (!attr.hasAssociationClass()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                String entityAbstractName = this.templateHelper.getEntityAbstractName(input);
                body.append("\n        " + entityAbstractName + " entityAbstract = (" + entityAbstractName + ")entity;\n        if (entityAbstract." + assocAttrName + " != null) {\n            tmp.add(entityAbstract." + assocAttrName + ");\n        }\n");
                continue;
            }
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String reverseAttrName = reverse.getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocClassName = GeneratorUtil.getSimpleName((String)assocClassFQN);
            String assocConcreteDaoClassFQN = this.templateHelper.getConcreteDaoFqn(attr.getAssociationClass());
            String assocConcreteDaoClassName = GeneratorUtil.getSimpleName((String)assocConcreteDaoClassFQN);
            this.addImport((ObjectModelClassifier)outputAbstract, assocClassFQN);
            this.addImport((ObjectModelClassifier)outputAbstract, assocConcreteDaoClassFQN);
            body.append("\n        {\n            " + assocConcreteDaoClassName + " dao = topiaDaoSupplier\n                    .getDao(" + assocClassName + ".class, " + assocConcreteDaoClassName + ".class);\n            List<" + assocClassName + "> findAllByProperties = dao.forProperties(\"" + reverseAttrName + "\", entity).findAll();\n            if (findAllByProperties != null) {\n                tmp.addAll(findAllByProperties);\n            }\n        }\n");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity e : tmp) {\n            if (e != null) {\n                result.add(e);\n                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());\n                result.addAll(dao.getComposite(e));\n            }\n        }\n        return result;\n    ");
        this.setOperationBody(operation, body.toString());
    }

    protected void generateAggregateOperation(ObjectModelClass outputAbstract, ObjectModelClass input) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)outputAbstract, "getAggregate", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)operation, Override.class);
        StringBuilder body = new StringBuilder();
        this.addImport((ObjectModelClassifier)outputAbstract, ArrayList.class);
        this.addImport((ObjectModelClassifier)outputAbstract, List.class);
        this.addImport((ObjectModelClassifier)outputAbstract, TopiaDao.class);
        body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.referenceClassifier() || !this.templateHelper.isEntity(attr.getClassifier()) || !attr.isAggregate()) continue;
            String attrName = attr.getName();
            String getterName = this.getJavaBeanMethodName("get", attrName);
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("        tmp.addAll(entity." + getterName + "());\n");
                continue;
            }
            body.append("        tmp.add(entity." + getterName + "());\n");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity e : tmp) {\n            result.add(e);\n            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());\n            result.addAll(dao.getAggregate(e));\n        }\n        return result;\n    ");
        this.setOperationBody(operation, body.toString());
    }
}

