/* *##% ToPIA - SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.topia.service.TopiaApplicationServiceAbstract;

/**
* ServiceImplGenerator.java
* 
* Created: 19 juin 2007
*
* @author ndupont
* @version $Revision: 1668 $
*  
* Genere l'entete du service implante.
*  
* L'implementation du service herite du service abstrait et donc des methodes qui
* appellent celles des DAOs et celles des entites.
* 
* L'implementation des methodes metiers est a la charge du developpeur.
* 
* @see ServiceInterfaceGenerator
* @see TopiaApplicationServiceAbstract
* 
* Mise a jour: $Date: 2009-11-13 14:01:01 +0100 (Fri, 13 Nov 2009) $
* par : $Author: fdesbois $
*/
public class ServiceImplGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(ServiceImplGenerator.class);

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + "Impl.java";
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
   	 
    	if (!interfacez.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_SERVICE)) {
            return;
        }
    	
    	// pas de génération s'il y a des méthodes métier du service à implémenter
    	if(interfacez.getOperations().size()>0){
    		return;
    	}
    	
    	// pas de génération s'il y a des méthodes métiers des entités à implémenter
        for (Iterator i=interfacez.getInterfaces().iterator(); i.hasNext();) {
            ObjectModelClassifier parent = (ObjectModelClassifier)i.next();
            // pour tous les DAOInterface
            if(parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)){
            	// récupérer la classe de l'object model correspondant à la DAO
            	String entityClassName = null;
            	entityClassName = parent.getQualifiedName().replace("DAO", "");
            	if(getModel().hasClass(entityClassName)){
            		ObjectModelClass clazz =  getModel().getClass(entityClassName);
            		if(clazz.getOperations().size()>0)
            			return;
            	}
            }		
        }

        // générer l'entête du service
        generateInterfaceHeader(output, interfacez);

/*{} //<%=interfacez.getName()%>
}*/
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
/*{package <%=classifier.getPackageName()%>;}*/
    	
        if (TopiaGeneratorUtil.hasDocumentation(classifier)) {
/*{
/**
 *
 * <%=classifier.getDocumentation()%>
 *)
}*/
        }
/*{

public class <%=classifierName%>Impl extends <%=classifierName%>Abstract { }*/
    }

} //ServiceImplGenerator
