/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.tables;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaEntityEnumProvider;
import org.nuiton.topia.persistence.metadata.TopiaMetadataEntity;
import org.nuiton.topia.persistence.metadata.TopiaMetadataModel;
import org.nuiton.topia.persistence.metadata.TopiaMetadataModelVisitor;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTables;

public class TopiaSqlTablesFactory {
    private static final Log log = LogFactory.getLog(TopiaSqlTablesFactory.class);
    protected final TopiaMetadataModel model;
    protected final TopiaEntityEnumProvider entityEnumProvider;

    public TopiaSqlTablesFactory(TopiaMetadataModel model, TopiaEntityEnumProvider entityEnumProvider) {
        this.model = model;
        this.entityEnumProvider = entityEnumProvider;
    }

    public TopiaSqlTables newReplicateEntityTables(TopiaSqlTablesPredicate predicate, TopiaEntityEnum ... entityEnums) {
        ReplicateTables tablesBuilder = new ReplicateTables(predicate);
        return tablesBuilder.getTables(entityEnums);
    }

    public class ReplicateTables
    implements TopiaMetadataModelVisitor {
        protected final TopiaSqlTablesPredicate predicate;
        protected final Set<TopiaMetadataEntity> dones;
        protected TopiaSqlTables.BuilderStepOnTable builder;
        protected TopiaSqlTables tables;

        public ReplicateTables(TopiaSqlTablesPredicate predicate) {
            this.predicate = predicate;
            this.dones = new LinkedHashSet<TopiaMetadataEntity>();
        }

        public TopiaSqlTables getTables(TopiaEntityEnum ... entityEnums) {
            this.visitModelStart(TopiaSqlTablesFactory.this.model);
            for (TopiaEntityEnum entityEnum : entityEnums) {
                TopiaMetadataEntity entity = TopiaSqlTablesFactory.this.model.getEntity(entityEnum.name());
                entity.accept((TopiaMetadataModelVisitor)this, TopiaSqlTablesFactory.this.model);
            }
            this.visitModelEnd(TopiaSqlTablesFactory.this.model);
            return this.tables;
        }

        public void visitModelStart(TopiaMetadataModel metadataModel) {
        }

        public void visitModelEnd(TopiaMetadataModel metadataModel) {
            this.tables = this.builder.build();
        }

        public void visitEntiyStart(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity) {
            boolean added;
            if (this.predicate.acceptEntity(metadataEntity) && (added = this.dones.add(metadataEntity))) {
                log.info((Object)("E \u2192 " + metadataEntity.getType()));
                TopiaEntityEnum entityEnum = TopiaSqlTablesFactory.this.entityEnumProvider.getEntityEnum(metadataEntity.getType());
                this.builder = (this.builder == null ? TopiaSqlTables.builder() : this.builder).addMainTable(entityEnum);
            }
        }

        public void visitEntiyEnd(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity) {
            if (this.dones.contains(metadataEntity)) {
                log.info((Object)("E \u2190 " + metadataEntity.getType()));
            }
        }

        public void visitReversedAssociation(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity, String propertyName, TopiaMetadataEntity propertyType) {
            if (this.predicate.acceptReversedAssociation(metadataEntity, propertyName, propertyType)) {
                TopiaEntityEnum entityEnum = TopiaSqlTablesFactory.this.entityEnumProvider.getEntityEnum(propertyType.getType());
                boolean withShell = propertyType.withShell();
                log.info((Object)(metadataEntity.getType() + "/" + propertyName + "\u2192" + propertyType.getType() + " (withShell: " + withShell + ")"));
                if (withShell) {
                    this.builder = this.builder.addAndEnterReverseJoinTable(entityEnum);
                    this.visitChild(propertyType);
                } else {
                    this.builder = this.builder.addReverseJoinTable(entityEnum);
                }
            }
        }

        public void visitAssociation(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity, String propertyName, TopiaMetadataEntity propertyType) {
            if (this.predicate.acceptAssociation(metadataEntity, propertyName, propertyType)) {
                TopiaEntityEnum entityEnum = TopiaSqlTablesFactory.this.entityEnumProvider.getEntityEnum(propertyType.getType());
                boolean withShell = propertyType.withShell();
                log.info((Object)(metadataEntity.getType() + "/" + propertyName + "\u2192" + propertyType.getType() + " (withShell: " + withShell + ")"));
                if (withShell) {
                    this.builder = this.builder.addAndEnterJoinTable(entityEnum);
                    this.visitChild(propertyType);
                } else {
                    this.builder = this.builder.addJoinTable(entityEnum);
                }
            }
        }

        public void visitNmAssociation(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity, String propertyName, TopiaMetadataEntity propertyType) {
            if (this.predicate.acceptNmAssociation(metadataEntity, propertyName, propertyType)) {
                log.info((Object)(metadataEntity.getType() + "/" + propertyName + "\u2192" + propertyType.getType()));
                this.builder = this.builder.addAssociationTable(propertyName);
            }
        }

        public void visitRequired(TopiaMetadataModel metadataModel, TopiaMetadataEntity metadataEntity, String propertyName, TopiaMetadataEntity propertyType) {
        }

        protected void visitChild(TopiaMetadataEntity propertyType) {
            this.dones.add(propertyType);
            propertyType.accept((TopiaMetadataModelVisitor)this, TopiaSqlTablesFactory.this.model);
            this.builder = this.builder.backToParent();
        }
    }

    public static interface TopiaSqlTablesPredicate {
        public boolean acceptEntity(TopiaMetadataEntity var1);

        public boolean acceptAssociation(TopiaMetadataEntity var1, String var2, TopiaMetadataEntity var3);

        public boolean acceptReversedAssociation(TopiaMetadataEntity var1, String var2, TopiaMetadataEntity var3);

        public boolean acceptNmAssociation(TopiaMetadataEntity var1, String var2, TopiaMetadataEntity var3);
    }
}

