/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.base.Preconditions;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;

public abstract class AbstractSqlRequest {
    private static final Log log = LogFactory.getLog(AbstractSqlRequest.class);
    protected TopiaApplicationContext sourceTopiaApplicationContext;
    protected TopiaApplicationContext targetTopiaApplicationContext;
    protected Writer writer;

    public TopiaApplicationContext getTargetTopiaApplicationContext() {
        return this.targetTopiaApplicationContext;
    }

    protected void setTargetTopiaApplicationContext(TopiaApplicationContext targetTopiaApplicationContext) {
        this.targetTopiaApplicationContext = targetTopiaApplicationContext;
    }

    public TopiaApplicationContext getSourceTopiaApplicationContext() {
        return this.sourceTopiaApplicationContext;
    }

    protected void setSourceTopiaApplicationContext(TopiaApplicationContext sourceTopiaApplicationContext) {
        this.sourceTopiaApplicationContext = sourceTopiaApplicationContext;
    }

    public Writer getWriter() {
        return this.writer;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    public static abstract class AbstractSqlRequestBuilder<B extends AbstractSqlRequestBuilder, R extends AbstractSqlRequest> {
        protected final R request;

        protected AbstractSqlRequestBuilder(R request) {
            this.request = request;
        }

        public B from(TopiaApplicationContext sourceTopiaApplicationContext) {
            ((AbstractSqlRequest)this.request).setSourceTopiaApplicationContext(sourceTopiaApplicationContext);
            return this.returnThis();
        }

        public B to(TopiaApplicationContext targetTopiaApplicationContext) {
            ((AbstractSqlRequest)this.request).setTargetTopiaApplicationContext(targetTopiaApplicationContext);
            return this.returnThis();
        }

        public B to(Writer writer) {
            ((AbstractSqlRequest)this.request).setWriter(writer);
            return this.returnThis();
        }

        public R build() {
            this.checkParams();
            return this.request;
        }

        protected void checkParams() {
            Preconditions.checkState((((AbstractSqlRequest)this.request).getSourceTopiaApplicationContext() != null ? 1 : 0) != 0, (Object)"No sourceTopiaApplicationContext defined");
            Preconditions.checkState((((AbstractSqlRequest)this.request).getWriter() != null || ((AbstractSqlRequest)this.request).getTargetTopiaApplicationContext() != null ? 1 : 0) != 0, (Object)"No targetTopiaApplicationContext, nor writer defined");
        }

        protected B returnThis() {
            return (B)this;
        }
    }
}

