package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Thu Oct 31 23:55:04 CET 2013")
public abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : enabled
     */
    protected boolean enabled;

    /**
     * Nom de l'attribut en BD : lastConnectionDate
     */
    protected Date lastConnectionDate;

    /**
     * Nom de l'attribut en BD : numberOfConnection
     */
    protected int numberOfConnection;

    /**
     * Nom de l'attribut en BD : link
     */
    protected String link;

    /**
     * Nom de l'attribut en BD : principals
     */
    protected Collection<TaasPrincipal> principals;

    private static final long serialVersionUID = 3691037660360630576L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, EMAIL, String.class, email);
        visitor.visit(this, ENABLED, boolean.class, enabled);
        visitor.visit(this, LAST_CONNECTION_DATE, Date.class, lastConnectionDate);
        visitor.visit(this, NUMBER_OF_CONNECTION, int.class, numberOfConnection);
        visitor.visit(this, LINK, String.class, link);
        visitor.visit(this, PRINCIPALS, Collection.class, TaasPrincipal.class, principals);
        visitor.end(this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(EMAIL, email);
        String result = this.email;
        fireOnPostRead(EMAIL, email);
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        fireOnPreWrite(ENABLED, oldValue, enabled);
        this.enabled = enabled;
        fireOnPostWrite(ENABLED, oldValue, enabled);
    }

    @Override
    public boolean isEnabled() {
        fireOnPreRead(ENABLED, enabled);
        boolean result = this.enabled;
        fireOnPostRead(ENABLED, enabled);
        return result;
    }

    @Override
    public boolean getEnabled() {
        fireOnPreRead(ENABLED, enabled);
        boolean result = this.enabled;
        fireOnPostRead(ENABLED, enabled);
        return result;
    }

    @Override
    public void setLastConnectionDate(Date lastConnectionDate) {
        Date oldValue = this.lastConnectionDate;
        fireOnPreWrite(LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
        this.lastConnectionDate = lastConnectionDate;
        fireOnPostWrite(LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
    }

    @Override
    public Date getLastConnectionDate() {
        fireOnPreRead(LAST_CONNECTION_DATE, lastConnectionDate);
        Date result = this.lastConnectionDate;
        fireOnPostRead(LAST_CONNECTION_DATE, lastConnectionDate);
        return result;
    }

    @Override
    public void setNumberOfConnection(int numberOfConnection) {
        int oldValue = this.numberOfConnection;
        fireOnPreWrite(NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
        this.numberOfConnection = numberOfConnection;
        fireOnPostWrite(NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
    }

    @Override
    public int getNumberOfConnection() {
        fireOnPreRead(NUMBER_OF_CONNECTION, numberOfConnection);
        int result = this.numberOfConnection;
        fireOnPostRead(NUMBER_OF_CONNECTION, numberOfConnection);
        return result;
    }

    @Override
    public void setLink(String link) {
        String oldValue = this.link;
        fireOnPreWrite(LINK, oldValue, link);
        this.link = link;
        fireOnPostWrite(LINK, oldValue, link);
    }

    @Override
    public String getLink() {
        fireOnPreRead(LINK, link);
        String result = this.link;
        fireOnPostRead(LINK, link);
        return result;
    }

    @Override
    public void addPrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PRINCIPALS, null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }

        this.principals.add(principals);
        fireOnPostWrite(PRINCIPALS, this.principals.size(), null, principals);
    }

    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> principals) {
        if (principals == null) {
            return;
        }
        for (TaasPrincipal item : principals) {
            addPrincipals(item);
        }
    }

    @Override
    public void setPrincipals(Collection<TaasPrincipal> principals) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasPrincipal> oldValue = this.principals != null ? new ArrayList<TaasPrincipal>(this.principals) : null;
        fireOnPreWrite(PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PRINCIPALS, oldValue, principals);
    }

    @Override
    public void removePrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PRINCIPALS, principals, null);
        if (this.principals == null || !this.principals.remove(principals)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PRINCIPALS, this.principals.size() + 1, principals, null);
    }

    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite(PRINCIPALS, oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite(PRINCIPALS, oldValue, this.principals);
    }

    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
    }

    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
    }

    @Override
    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
    }

    @Override
    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(PASSWORD, this.password).
            append(EMAIL, this.email).
            append(ENABLED, this.enabled).
            append(LAST_CONNECTION_DATE, this.lastConnectionDate).
            append(NUMBER_OF_CONNECTION, this.numberOfConnection).
            append(LINK, this.link).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
    }

} //TaasUserAbstract
