package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Thu Oct 31 23:55:04 CET 2013")
public abstract class TopiaUserAbstract extends TopiaEntityAbstract implements TopiaUser {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : note
     */
    protected String note;

    /**
     * Nom de l'attribut en BD : linkApplication
     */
    protected String linkApplication;

    /**
     * Nom de l'attribut en BD : topiaGroup
     */
    protected Collection<TopiaGroup> topiaGroup;

    private static final long serialVersionUID = 3775485650828419892L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, EMAIL, String.class, email);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, NOTE, String.class, note);
        visitor.visit(this, LINK_APPLICATION, String.class, linkApplication);
        visitor.visit(this, TOPIA_GROUP, Collection.class, TopiaGroup.class, topiaGroup);
        visitor.end(this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(EMAIL, email);
        String result = this.email;
        fireOnPostRead(EMAIL, email);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
    }

    @Override
    public void setNote(String note) {
        String oldValue = this.note;
        fireOnPreWrite(NOTE, oldValue, note);
        this.note = note;
        fireOnPostWrite(NOTE, oldValue, note);
    }

    @Override
    public String getNote() {
        fireOnPreRead(NOTE, note);
        String result = this.note;
        fireOnPostRead(NOTE, note);
        return result;
    }

    @Override
    public void setLinkApplication(String linkApplication) {
        String oldValue = this.linkApplication;
        fireOnPreWrite(LINK_APPLICATION, oldValue, linkApplication);
        this.linkApplication = linkApplication;
        fireOnPostWrite(LINK_APPLICATION, oldValue, linkApplication);
    }

    @Override
    public String getLinkApplication() {
        fireOnPreRead(LINK_APPLICATION, linkApplication);
        String result = this.linkApplication;
        fireOnPostRead(LINK_APPLICATION, linkApplication);
        return result;
    }

    @Override
    public void addTopiaGroup(TopiaGroup topiaGroup) {
        fireOnPreWrite(TOPIA_GROUP, null, topiaGroup);
        if (this.topiaGroup == null) {
            this.topiaGroup = new ArrayList<TopiaGroup>();
        }

        if (topiaGroup.getTopiaUser() == null) {
            topiaGroup.setTopiaUser(new ArrayList<TopiaUser>());
        }
        topiaGroup.getTopiaUser().add(this);

        this.topiaGroup.add(topiaGroup);
        fireOnPostWrite(TOPIA_GROUP, this.topiaGroup.size(), null, topiaGroup);
    }

    @Override
    public void addAllTopiaGroup(Collection<TopiaGroup> topiaGroup) {
        if (topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : topiaGroup) {
            addTopiaGroup(item);
        }
    }

    @Override
    public void setTopiaGroup(Collection<TopiaGroup> topiaGroup) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaGroup> oldValue = this.topiaGroup != null ? new ArrayList<TopiaGroup>(this.topiaGroup) : null;
        fireOnPreWrite(TOPIA_GROUP, oldValue, topiaGroup);
        this.topiaGroup = topiaGroup;
        fireOnPostWrite(TOPIA_GROUP, oldValue, topiaGroup);
    }

    @Override
    public void removeTopiaGroup(TopiaGroup topiaGroup) {
        fireOnPreWrite(TOPIA_GROUP, topiaGroup, null);
        if (this.topiaGroup == null || !this.topiaGroup.remove(topiaGroup)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        topiaGroup.getTopiaUser().remove(this);

        fireOnPostWrite(TOPIA_GROUP, this.topiaGroup.size() + 1, topiaGroup, null);
    }

    @Override
    public void clearTopiaGroup() {
        if (this.topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : this.topiaGroup) {
            item.getTopiaUser().remove(this);
        }
        Collection<TopiaGroup> oldValue = new ArrayList<TopiaGroup>(this.topiaGroup);
        fireOnPreWrite(TOPIA_GROUP, oldValue, this.topiaGroup);
        this.topiaGroup.clear();
        fireOnPostWrite(TOPIA_GROUP, oldValue, this.topiaGroup);
    }

    @Override
    public Collection<TopiaGroup> getTopiaGroup() {
        return topiaGroup;
    }

    @Override
    public TopiaGroup getTopiaGroupByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(topiaGroup, topiaId);
    }

    @Override
    public int sizeTopiaGroup() {
        if (topiaGroup == null) {
            return 0;
        }
        return topiaGroup.size();
    }

    @Override
    public boolean isTopiaGroupEmpty() {
        int size = sizeTopiaGroup();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(EMAIL, this.email).
            append(PASSWORD, this.password).
            append(NOTE, this.note).
            append(LINK_APPLICATION, this.linkApplication).
         toString();
        return result;
    }

} //TopiaUserAbstract
