package org.nuiton.topia.security.entities.authorization;

import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Thu Aug 08 17:30:45 CEST 2013")
public abstract class TopiaEntityAuthorizationAbstract extends TopiaAuthorizationImpl implements TopiaEntityAuthorization {

    /**
     * Nom de l'attribut en BD : expression
     */
    protected String expression;

    /**
     * Nom de l'attribut en BD : actions
     */
    protected int actions;

    /**
     * Nom de l'attribut en BD : principals
     */
    protected Set principals;

    private static final long serialVersionUID = 7090412080148341350L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, EXPRESSION, String.class, expression);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.visit(this, PRINCIPALS, Set.class, principals);
        visitor.end(this);
    }

    @Override
    public void setExpression(String expression) {
        String oldValue = this.expression;
        fireOnPreWrite(EXPRESSION, oldValue, expression);
        this.expression = expression;
        fireOnPostWrite(EXPRESSION, oldValue, expression);
    }

    @Override
    public String getExpression() {
        fireOnPreRead(EXPRESSION, expression);
        String result = this.expression;
        fireOnPostRead(EXPRESSION, expression);
        return result;
    }

    @Override
    public void setActions(int actions) {
        int oldValue = this.actions;
        fireOnPreWrite(ACTIONS, oldValue, actions);
        this.actions = actions;
        fireOnPostWrite(ACTIONS, oldValue, actions);
    }

    @Override
    public int getActions() {
        fireOnPreRead(ACTIONS, actions);
        int result = this.actions;
        fireOnPostRead(ACTIONS, actions);
        return result;
    }

    @Override
    public void setPrincipals(Set principals) {
        Set oldValue = this.principals;
        fireOnPreWrite(PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PRINCIPALS, oldValue, principals);
    }

    @Override
    public Set getPrincipals() {
        fireOnPreRead(PRINCIPALS, principals);
        Set result = this.principals;
        fireOnPostRead(PRINCIPALS, principals);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(EXPRESSION, this.expression).
            append(ACTIONS, this.actions).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
    }

} //TopiaEntityAuthorizationAbstract
