package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Sun Mar 22 16:44:41 UTC 2015")
public abstract class TaasAuthorizationAbstract extends TopiaEntityAbstract implements TaasAuthorization {

    /**
     * Nom de l'attribut en BD : expression
     */
    protected String expression;

    /**
     * Nom de l'attribut en BD : actions
     */
    protected int actions;

    private static final long serialVersionUID = 3904955563887912290L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_EXPRESSION, String.class, expression);
        visitor.visit(this, PROPERTY_ACTIONS, int.class, actions);
    }

    @Override
    public void setExpression(String expression) {
        String oldValue = this.expression;
        fireOnPreWrite(PROPERTY_EXPRESSION, oldValue, expression);
        this.expression = expression;
        fireOnPostWrite(PROPERTY_EXPRESSION, oldValue, expression);
    }

    @Override
    public String getExpression() {
        fireOnPreRead(PROPERTY_EXPRESSION, expression);

        String result = this.expression;

        fireOnPostRead(PROPERTY_EXPRESSION, expression);

        return result;
    }

    @Override
    public void setActions(int actions) {
        int oldValue = this.actions;
        fireOnPreWrite(PROPERTY_ACTIONS, oldValue, actions);
        this.actions = actions;
        fireOnPostWrite(PROPERTY_ACTIONS, oldValue, actions);
    }

    @Override
    public int getActions() {
        fireOnPreRead(PROPERTY_ACTIONS, actions);

        int result = this.actions;

        fireOnPostRead(PROPERTY_ACTIONS, actions);

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_EXPRESSION, this.expression).
            append(PROPERTY_ACTIONS, this.actions).
         toString();
        return result;
    }

} //TaasAuthorizationAbstract
