/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.listener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;

public class PropertyWriteListener
implements VetoableChangeListener {
    private static Log log = LogFactory.getLog(PropertyWriteListener.class);
    private TopiaSecurityServiceImpl securityManager;

    public PropertyWriteListener(TopiaSecurityServiceImpl securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Object source = event.getSource();
        TopiaEntityAbstract entity = (TopiaEntityAbstract)source;
        try {
            this.securityManager.checkPermission(entity.getTopiaId(), 4);
        }
        catch (SecurityException te) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("[Security] Write denied to : " + entity.getTopiaId()), (Throwable)te);
            }
            throw new SecurityException("Access denied to Write entity " + entity.getTopiaId() + " on " + event.getPropertyName(), te);
        }
    }
}

