/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.jaas;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;

public class TopiaPolicy
extends Policy {
    private Log log = LogFactory.getLog(TopiaPolicy.class);
    private TopiaSecurityServiceImpl securityManager;
    protected Policy parentPolicy;

    public TopiaPolicy(TopiaSecurityServiceImpl securityManager) {
        this.securityManager = securityManager;
    }

    public Policy getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(Policy parentPolicy) {
        this.parentPolicy = parentPolicy;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = this.parentPolicy.getPermissions(codesource);
        return pc;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = this.parentPolicy.getPermissions(domain);
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                String principalName = principal.getName();
                Set<Permission> permissions = this.securityManager.getPermissionsCache(principalName);
                if (permissions == null) {
                    try {
                        permissions = this.securityManager.putPermissionsCache(principalName);
                    }
                    catch (TopiaException e) {
                        this.log.error((Object)"R\u00e9cup\u00e9ration des TopiaPermission impossible", (Throwable)e);
                    }
                }
                for (Permission permission : permissions) {
                    pc.add(permission);
                }
            }
        } else {
            this.log.error((Object)"R\u00e9cup\u00e9ration des TopiaPermission impossible");
        }
        return pc;
    }

    @Override
    public void refresh() {
        this.parentPolicy.refresh();
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc = this.getPermissions(domain);
        if (pc == null) {
            return false;
        }
        return pc.implies(permission);
    }

    public void installPolicy() {
        Policy policy = Policy.getPolicy();
        if (policy == this) {
            return;
        }
        if (policy instanceof TopiaPolicy) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Policy deja modifie en: " + policy));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("l'ancienne Policy etait: " + policy));
            }
            this.setParentPolicy(policy);
            Policy.setPolicy(this);
        }
    }
}

