/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.TopiaSecurityService;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

public class TopiaSecurityFactoryFilter {
    private static Log log = LogFactory.getLog(TopiaSecurityUtil.class);
    private static final long serialVersionUID = 1L;
    private TopiaSecurityService securityManager;

    public TopiaSecurityFactoryFilter(TopiaSecurityService securityManager) {
        this.securityManager = securityManager;
    }

    public void filter(Collection<TopiaEntity> entities, int actions, String ... fields) {
        throw new UnsupportedOperationException();
    }

    public TopiaEntity filter(TopiaEntity entity, int actions) {
        try {
            this.securityManager.checkPermission(entity.getTopiaId(), actions);
        }
        catch (SecurityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Return Null because : " + e));
            }
            return null;
        }
        return entity;
    }

    public <E extends TopiaEntity> Collection<E> filter(Collection<E> entities, int actions) {
        ArrayList<E> result = new ArrayList<E>(entities);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            TopiaEntity entity = (TopiaEntity)iterator.next();
            try {
                this.securityManager.checkPermission(entity.getTopiaId(), actions);
            }
            catch (SecurityException e) {
                iterator.remove();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removed because : " + e));
            }
        }
        return result;
    }

    public <E extends TopiaEntity> List<E> filter(List<E> entities, int actions) {
        return (List)this.filter((Collection<E>)entities, actions);
    }
}

