/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.migration.mappings.TMSVersionDAO;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.VersionBuilder;

public class TMSVersionPersister {
    private static final Log log = LogFactory.getLog(TMSVersionPersister.class);
    protected final Configuration versionConfiguration;
    protected final Configuration legacyVersionConfiguration;
    protected Boolean versionTableExist;
    protected Boolean legacyVersionTableExist;

    public TMSVersionPersister(Configuration versionConfiguration, Configuration legacyVersionConfiguration) {
        this.versionConfiguration = versionConfiguration;
        this.legacyVersionConfiguration = legacyVersionConfiguration;
    }

    public boolean isLegacyVersionTableExist() {
        if (this.legacyVersionTableExist == null) {
            this.legacyVersionTableExist = TopiaUtil.isSchemaExist((Configuration)this.legacyVersionConfiguration, (String)TMSVersion.class.getName());
        }
        return this.legacyVersionTableExist;
    }

    public boolean isVersionTableExist() {
        if (this.versionTableExist == null) {
            this.versionTableExist = TopiaUtil.isSchemaExist((Configuration)this.versionConfiguration, (String)TMSVersion.class.getName());
        }
        return this.versionTableExist;
    }

    public void saveVersion(TopiaContext tx, Version version) throws TopiaException {
        Version dbVersion;
        if (log.isInfoEnabled()) {
            log.info((Object)("Table exists        = " + this.isVersionTableExist()));
            log.info((Object)("Legacy table exists = " + this.isLegacyVersionTableExist()));
        }
        if (this.isLegacyVersionTableExist()) {
            this.deleteLegacyTable();
        }
        if (this.isVersionTableExist()) {
            dbVersion = this.getVersion(tx);
        } else {
            dbVersion = null;
            this.createTableIfRequired();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Db version          = " + dbVersion));
            log.info((Object)("Version to save     = " + version));
        }
        if (ObjectUtils.notEqual((Object)dbVersion, (Object)version)) {
            this.persistVersion(tx, version);
        }
    }

    protected Version getVersion(TopiaContext tx) throws TopiaException {
        TMSVersion tmsVersion = TMSVersionDAO.get(tx);
        Version version = tmsVersion == null ? null : VersionBuilder.create((String)tmsVersion.getVersion()).build();
        return version;
    }

    protected void persistVersion(TopiaContext tx, Version version) throws TopiaException {
        TMSVersionDAO.deleteAll(tx);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"topia.migration.saving.db.version", (Object[])new Object[]{version}));
        }
        TMSVersion tmsVersion = TMSVersionDAO.create(tx, version.getVersion());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created version : " + tmsVersion.getVersion()));
        }
    }

    protected void createTableIfRequired() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding tms_version table");
        }
        TMSVersionDAO.createTable(this.versionConfiguration);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Table for " + TMSVersion.class.getSimpleName() + " created"));
        }
        this.versionTableExist = true;
    }

    protected void deleteLegacyTable() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will drop legacy tmsVersion table");
        }
        TMSVersionDAO.dropTable(this.legacyVersionConfiguration);
        this.legacyVersionTableExist = false;
    }
}

