package org.nuiton.topia.migration;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TMSVersion.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TMSVersionDAOAbstract<E extends TMSVersion> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TMSVersion.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut version
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * version le paramètre
     * @param v la valeur que doit avoir version
     * @return un element ou null
     */
    public E findByVersion(java.lang.String v) throws TopiaException {
        E result = findByProperty("version", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * version le paramètre
     * @param v la valeur que doit avoir version
     * @return une liste
     */
    public List<E> findAllByVersion(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("version", v);
        return result;
    }

} // TMSVersionDAOAbstract
