/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.util.Version;

public abstract class ManualMigrationCallback {
    private static Log log = LogFactory.getLog(ManualMigrationCallback.class);

    public abstract boolean askUser(Version var1, Version var2, List<Version> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationChoice doMigration(TopiaContext ctxt, Version dbVersion, Version applicationVersion, List<Version> versions) {
        MigrationChoice result = MigrationChoice.NO_MIGRATION;
        boolean doMigrate = this.askUser(dbVersion, applicationVersion, versions);
        if (doMigrate) {
            TopiaContextImplementor tx = null;
            for (Version v : versions) {
                try {
                    tx = (TopiaContextImplementor)ctxt.beginTransaction();
                    try {
                        String methodName = "migrateTo_" + v.getValidName();
                        Method m = this.getClass().getMethod(methodName, TopiaContextImplementor.class);
                        m.setAccessible(true);
                        log.info((Object)I18n._((String)"topia.migration.start.migrate", (Object[])new Object[]{v}));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("launch method " + methodName));
                        }
                        m.invoke((Object)this, tx);
                        tx.commitTransaction();
                        result = MigrationChoice.CUSTOM_MIGRATION;
                    }
                    catch (Exception eee) {
                        log.error((Object)"Migration impossible de la base", (Throwable)eee);
                        tx.rollbackTransaction();
                    }
                    finally {
                        if (tx != null) {
                            tx.closeContext();
                        }
                    }
                }
                catch (Exception eee) {
                    log.error((Object)"Error lors de la tentative de migration", (Throwable)eee);
                }
            }
        }
        return result;
    }

    public void executeSQL(TopiaContextImplementor tx, final String ... sqls) throws TopiaException {
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                for (String sql : sqls) {
                    log.info((Object)sql);
                    PreparedStatement sta = connection.prepareStatement(sql);
                    sta.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("done " + sql));
                    }
                    sta.close();
                }
            }
        });
    }

    public static enum MigrationChoice {
        NO_MIGRATION,
        MIGRATION,
        CUSTOM_MIGRATION;

    }
}

