/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.metadata;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaEntityEnumProvider;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.ColumnMeta;
import org.nuiton.topia.persistence.metadata.MetaFilenameAware;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class TableMeta<T extends TopiaEntityEnum>
implements Serializable,
Iterable<ColumnMeta>,
MetaFilenameAware<T> {
    private static final long serialVersionUID = 1L;
    protected final T source;
    protected List<ColumnMeta> columns;
    protected final Set<T> dependencies;
    protected List<AssociationMeta<T>> associations;
    protected Binder<TopiaEntity, TopiaEntity> binder;
    protected transient EntityOperator<TopiaEntity> operator;
    protected boolean useNaturalIdsOrNotNulls;

    public static <T extends TopiaEntityEnum> TableMeta<T> newMeta(T entityEnum, TopiaEntityEnumProvider<T> typeProvider) {
        return new TableMeta<T>(entityEnum, typeProvider);
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.source.name();
    }

    @Override
    public String getFilename() {
        return this.source.name() + ".csv";
    }

    @Override
    public File newFile(File container) {
        return new File(container, this.getFilename());
    }

    @Override
    public Writer newWriter(File container) {
        File file = this.newFile(container);
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TopiaException("Could not find file " + file);
        }
    }

    public String toString() {
        return "<" + this.source + ">";
    }

    public Class<? extends TopiaEntity> getEntityType() {
        return this.source.getContract();
    }

    public ColumnMeta getColumns(String columnName) {
        Preconditions.checkNotNull((Object)columnName);
        ColumnMeta result = null;
        for (ColumnMeta columnMeta : this.getColumns()) {
            if (!columnName.equals(columnMeta.getName())) continue;
            result = columnMeta;
            break;
        }
        return result;
    }

    public String[] getColumnNamesAsArray() {
        List<String> columnNames = this.getColumnNames();
        return columnNames.toArray(new String[columnNames.size()]);
    }

    public List<String> getColumnNames() {
        LinkedList result = Lists.newLinkedList();
        for (ColumnMeta columnMeta : this.getColumns()) {
            result.add(columnMeta.getName());
        }
        return result;
    }

    public List<ColumnMeta> getColumns() {
        return this.columns;
    }

    public List<AssociationMeta<T>> getAssociations() {
        return this.associations;
    }

    public Set<T> getDependencies() {
        return this.dependencies;
    }

    public AssociationMeta<T> getAssociations(String name) {
        AssociationMeta<T> result = null;
        for (AssociationMeta<T> meta : this.getAssociations()) {
            if (!name.equals(meta.getName())) continue;
            result = meta;
            break;
        }
        return result;
    }

    public void copy(TopiaEntity source, TopiaEntity target) {
        this.getBinder().copy((Object)source, (Object)target, new String[0]);
    }

    public Map<String, Object> prepareCreate(TopiaEntity bean, String topiaId) {
        Map<String, Object> result = this.getOperator().getNaturalIsdAndNotNulls(bean);
        if (topiaId != null) {
            result.put("topiaId", topiaId);
        }
        return result;
    }

    @Override
    public Iterator<ColumnMeta> iterator() {
        return this.getColumns().iterator();
    }

    public TopiaEntity newEntity() {
        return (TopiaEntity)ObjectUtil.newInstance(this.source.getImplementation(), (String[])new String[0]);
    }

    protected Binder<TopiaEntity, TopiaEntity> getBinder() {
        if (this.binder == null) {
            BinderModelBuilder binderModelBuilder = BinderModelBuilder.newEmptyBuilder(this.getEntityType());
            for (ColumnMeta columnMeta : this) {
                binderModelBuilder.addSimpleProperties(new String[]{columnMeta.getName()});
            }
            this.binder = binderModelBuilder.toBinder();
        }
        return this.binder;
    }

    protected TableMeta(T source, TopiaEntityEnumProvider<T> typeProvider) {
        Serializable meta;
        Preconditions.checkNotNull(source);
        this.source = source;
        this.associations = Lists.newArrayList();
        this.columns = Lists.newLinkedList();
        HashSet deps = Sets.newHashSet();
        List<String> associationProperties = this.getOperator().getAssociationProperties();
        for (String property : associationProperties) {
            Class<?> propertyType = this.getOperator().getAssociationPropertyType(property);
            if (!TopiaEntity.class.isAssignableFrom(propertyType)) continue;
            T targetEnum = typeProvider.getEntityEnum(propertyType);
            meta = AssociationMeta.newMeta(source, targetEnum, property);
            this.associations.add((AssociationMeta<T>)meta);
        }
        ArrayList properties = Lists.newArrayList(this.getOperator().getProperties());
        properties.removeAll(associationProperties);
        for (String property : properties) {
            Class<?> propertyType = this.getOperator().getPropertyType(property);
            meta = ColumnMeta.newMeta(property, propertyType);
            this.columns.add((ColumnMeta)meta);
            if (!((ColumnMeta)meta).isFK()) continue;
            T dependency = typeProvider.getEntityEnum(propertyType);
            deps.add(dependency);
        }
        this.dependencies = deps;
        this.useNaturalIdsOrNotNulls = source.isUseNotNulls() || source.isUseNaturalIds();
    }

    public EntityOperator<TopiaEntity> getOperator() {
        if (this.operator == null) {
            this.operator = EntityOperatorStore.getOperator(this.source);
        }
        return this.operator;
    }
}

