package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaQueryBuilderAddCriteriaStep.java 2872 2013-11-15 09:51:40Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-6/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaQueryBuilderAddCriteriaStep.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Set;

/**
 * Represents a step when building a query to add a constraint.
 *
 * The builder implements the fluent interface DP, so you can add multiple
 * constraints by chaining calls.
 *
 * @author bleny
 * @since 3.0
 */
public interface TopiaQueryBuilderAddCriteriaStep<E extends TopiaEntity> {

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property.
     * @param value the value the field of the entity must be equals to argument
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addEquals(String property, Object value);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property.
     * @param value the value the field of the entity must not be equals to argument
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotEquals(String property, Object value);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property
     * @param values the value the field of the entity must be equals to one of the given values
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addIn(String property, Iterable<Object> values);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property
     * @param values the value the field of the entity must not be equals to any of the given values
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotIn(String property, Iterable<Object> values);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-many or a many-to-many property
     * @param value the property of the entity must be a collection that contains value
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addContains(String property, Object value);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-many or a many-to-many property
     * @param value the property of the entity must be a collection that doesn't contain value
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotContains(String property, Object value);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNull(String property);

    /**
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotNull(String property);

    /**
     * This method has the same behavior as {@link #addEquals(String, Object)} but
     * you don't need to have the entity but only the topiaId.
     *
     * @param property the name of a field of the queried entity, must be
     *                 a one-to-one or a many-to-one property
     * @param topiaId the
     */
    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdEquals(String property, String topiaId);

    TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdIn(String property, Iterable<String> topiaIds);

    TopiaQueryBuilderRunQueryStep<E> setOrderByArguments(Set<String> orderByArguments);

    TopiaQueryBuilderRunQueryStep<E> setOrderByArguments(String... orderByArguments);

}
