/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaPersistenceContext;

public class TopiaHibernateSessionRegistry {
    private static final Log log = LogFactory.getLog(TopiaHibernateSessionRegistry.class);
    protected WeakHashMap<Session, WeakReference<TopiaPersistenceContext>> registry = new WeakHashMap();

    public void register(Session session, TopiaPersistenceContext persistenceContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New Session<->TopiaPersistenceContext registration");
        }
        Preconditions.checkArgument((session != null ? 1 : 0) != 0);
        Preconditions.checkArgument((persistenceContext != null ? 1 : 0) != 0);
        WeakReference<TopiaPersistenceContext> reference = new WeakReference<TopiaPersistenceContext>(persistenceContext);
        this.registry.put(session, reference);
    }

    public TopiaPersistenceContext getPersistenceContext(Session session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0);
        WeakReference<TopiaPersistenceContext> reference = this.registry.get(session);
        TopiaPersistenceContext result = null;
        if (reference != null) {
            result = (TopiaPersistenceContext)reference.get();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get TopiaPersistenceContext from Session : " + (result == null ? "Not found" : "HIT !")));
        }
        return result;
    }

    public void unregister(Session session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0);
        WeakReference<TopiaPersistenceContext> reference = this.registry.remove(session);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove TopiaPersistenceContext from Session : " + (reference != null)));
        }
    }
}

