/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.service.jdbc.connections.internal.DriverManagerConnectionProviderImpl;

public class TopiaConnectionProviderHardCoded
extends DriverManagerConnectionProviderImpl {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final ArrayList pool = new ArrayList();
    private int poolSize;
    private int checkedOut = 0;
    private boolean autocommit;
    private static final Log log = LogFactory.getLog(TopiaConnectionProviderHardCoded.class);

    public void configure(Map configurationValues) throws HibernateException {
        String directory;
        String driverClass = (String)configurationValues.get("hibernate.connection.driver_class");
        this.poolSize = ConfigurationHelper.getInt((String)"hibernate.connection.pool_size", (Map)configurationValues, (int)20);
        log.info((Object)"Using Hibernate built-in connection pool (not for production use!)");
        log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)configurationValues);
        log.info((Object)("autocommit mode: " + this.autocommit));
        this.isolation = ConfigurationHelper.getInteger((String)"hibernate.connection.isolation", (Map)configurationValues);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation)));
        }
        if (driverClass == null) {
            log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)driverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + driverClass;
                    log.error((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, (Throwable)e);
                }
            }
        }
        this.url = directory = (String)configurationValues.get("testURL");
        this.connectionProps = ConnectionProviderInitiator.getConnectionProperties((Map)configurationValues);
        log.info((Object)("using driver: " + driverClass + " at URL: " + this.url));
        if (log.isDebugEnabled()) {
            log.info((Object)("connection properties: " + this.connectionProps));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("connection properties: " + ConfigurationHelper.maskOut((Properties)this.connectionProps, (String)"password")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("total checked-out connections: " + this.checkedOut));
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            if (!this.pool.isEmpty()) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + last));
                }
                ++this.checkedOut;
                Connection pooled = (Connection)this.pool.remove(last);
                if (this.isolation != null) {
                    pooled.setTransactionIsolation(this.isolation);
                }
                if (pooled.getAutoCommit() != this.autocommit) {
                    pooled.setAutoCommit(this.autocommit);
                }
                return pooled;
            }
        }
        log.debug((Object)"opening new JDBC connection");
        Connection conn = DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            conn.setTransactionIsolation(this.isolation);
        }
        if (conn.getAutoCommit() != this.autocommit) {
            conn.setAutoCommit(this.autocommit);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created connection to: " + this.url + ", Isolation Level: " + conn.getTransactionIsolation()));
        }
        ++this.checkedOut;
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        --this.checkedOut;
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            int currentSize = this.pool.size();
            if (currentSize < this.poolSize) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (currentSize + 1)));
                }
                this.pool.add(conn);
                return;
            }
        }
        log.debug((Object)"closing JDBC connection");
        conn.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        log.info((Object)("cleaning up connection pool: " + this.url));
        Iterator iter = this.pool.iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

