package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;


public  abstract class PersonAbstract extends TopiaEntityAbstract implements Person {

    protected String name;
    protected String firstname;
    protected Collection<Pet> pet;
static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.person");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.firstname");
    org.nuiton.i18n.I18n.n_("topia.test.common.pet");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_FIRSTNAME, String.class, firstname);
        visitor.visit(this, PROPERTY_PET, Collection.class, Pet.class, pet);
        visitor.end(this);
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
}

    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
}

    /**
     * setFirstname :
     * @param firstname 
     */

    @Override
    public void setFirstname(String firstname) {
        String oldValue = this.firstname;
        fireOnPreWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
        this.firstname = firstname;
        fireOnPostWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
}

    /**
     * getFirstname :
     * @return String 
     */

    @Override
    public String getFirstname() {
        fireOnPreRead(PROPERTY_FIRSTNAME, firstname);
        String result = this.firstname;
        fireOnPostRead(PROPERTY_FIRSTNAME, firstname);
        return result;
}

    /**
     * addPet :
     * @param pet 
     */

    @Override
    public void addPet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, null, pet);
        if (this.pet == null) {
            this.pet = new ArrayList<Pet>();
        }

        pet.setPerson(this);

        this.pet.add(pet);
        fireOnPostWrite(PROPERTY_PET, this.pet.size(), null, pet);
}

    /**
     * addAllPet :
     * @param pet 
     */

    @Override
    public void addAllPet(Collection<Pet> pet) {
        if (pet == null) {
            return;
        }
        for (Pet item : pet) {
            addPet(item);
        }
}

    /**
     * setPet :
     * @param pet 
     */

    @Override
    public void setPet(Collection<Pet> pet) {
        // Copy elements to keep data for fire with new reference
        Collection<Pet> oldValue = this.pet != null ? new ArrayList<Pet>(this.pet) : null;
        fireOnPreWrite(PROPERTY_PET, oldValue, pet);
        this.pet = pet;
        fireOnPostWrite(PROPERTY_PET, oldValue, pet);
}

    /**
     * removePet :
     * @param pet 
     */

    @Override
    public void removePet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, pet, null);
        if ((this.pet == null) || (!this.pet.remove(pet))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        pet.setPerson(null);

        fireOnPostWrite(PROPERTY_PET, this.pet.size() + 1, pet, null);
}

    /**
     * clearPet :
     */

    @Override
    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        Collection<Pet> oldValue = new ArrayList<Pet>(this.pet);
        fireOnPreWrite(PROPERTY_PET, oldValue, this.pet);
        this.pet.clear();
        fireOnPostWrite(PROPERTY_PET, oldValue, this.pet);
}

    /**
     * getPet :
     * @return Collection<Pet> 
     */

    @Override
    public Collection<Pet> getPet() {
        return pet;
}

    /**
     * getPetByTopiaId :
     * @param topiaId 
     * @return Pet 
     */

    @Override
    public Pet getPetByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pet, topiaId);
 }

    /**
     * sizePet :
     * @return int 
     */

    @Override
    public int sizePet() {
        if (pet == null) {
            return 0;
        }
        return pet.size();
}

    /**
     * isPetEmpty :
     * @return boolean 
     */

    @Override
    public boolean isPetEmpty() {
        int size = sizePet();
        return size == 0;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_FIRSTNAME, this.firstname).
         toString();
        return result;
}


} //PersonAbstract
