package org.nuiton.topia.persistence.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.Race;

/**
 * Test the {@link TopiaEntityRefTester} on
 * <p/>
 * <ul> <li>{@link Pet}</li> <li>{@link Race}</li> <li>{@link Person}</li>
 * </ul>
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.3.1
 */
public class TopiaEntityRefTesterTest extends TopiaEntityRefTester<TopiaTestEntityEnum> {

    /** Logger */
    private static final Log log =
            LogFactory.getLog(TopiaEntityRefTesterTest.class);

    private static final String PET1 = "pet1";

    private static final String PET2 = "pet2";

    private static final String RACE1 = "race1";

    private static final String PERSON1 = "person1";

    @Override
    protected TopiaTestEntityEnum[] getContracts0() {
        return new TopiaTestEntityEnum[]{
                TopiaTestEntityEnum.Pet,
                TopiaTestEntityEnum.Person,
                TopiaTestEntityEnum.Race,
        };
    }

    @Test
    public void testNoReferences() throws Exception {

        Pet pet = newEntity(TopiaTestEntityEnum.Pet, PET1);

        detectReferences(pet, 0);

        Race race = newEntity(TopiaTestEntityEnum.Race, RACE1);

        detectReferences(race, 0);

        Person person = newEntity(TopiaTestEntityEnum.Person, PERSON1);

        detectReferences(person, 0);

    }

    @Test
    public void testReferences() throws Exception {

        Pet pet = newEntity(TopiaTestEntityEnum.Pet, PET1);
        Race race = newEntity(TopiaTestEntityEnum.Race, RACE1);
        pet.setRace(race);
        Person person = newEntity(TopiaTestEntityEnum.Person, PERSON1);

        detectReferences(pet, 1, RACE1);

        nextEntry();
        assertCurrentEntry(race, 1);
        assertNextEntityRef(pet, Pet.RACE, pet, race);

        pet.setPerson(person);

        detectReferences(pet, 2, RACE1, PERSON1);

        nextEntry();
        assertCurrentEntry(person, 1);
        assertNextEntityRef(pet, Pet.PERSON, pet, person);

        nextEntry();
        assertCurrentEntry(race, 1);
        assertNextEntityRef(pet, Pet.RACE, pet, race);

        person.addPet(pet);

        detectReferences(person, 1, PET1);

        nextEntry();
        assertCurrentEntry(pet, 1);
        assertNextAssociationEntityRef(person, Person.PET, PET1, person, pet);

        Pet pet2 = newEntity(TopiaTestEntityEnum.Pet, PET2);

        person.addPet(pet2);

        detectReferences(person, 3, PET1, PET2, RACE1);

        nextEntry();
        assertCurrentEntry(pet, 1);
        assertNextAssociationEntityRef(person, Person.PET, PET1, person, pet);

        nextEntry();
        assertCurrentEntry(pet2, 1);
        assertNextAssociationEntityRef(person, Person.PET, PET2, person, pet2);

        nextEntry();
        assertCurrentEntry(race, 1);
        assertNextEntityRef(pet, Pet.RACE, person, pet, race);

        pet2.setRace(race);

        detectReferences(person, 3, PET1, PET2, RACE1);

        nextEntry();
        assertCurrentEntry(pet, 1);
        assertNextAssociationEntityRef(person, Person.PET, PET1, person, pet);

        nextEntry();
        assertCurrentEntry(pet2, 1);
        assertNextAssociationEntityRef(person, Person.PET, PET2, person, pet2);

        nextEntry();
        assertCurrentEntry(race, 2);
        assertNextEntityRef(pet, Pet.RACE, person, pet, race);
        assertNextEntityRef(pet2, Pet.RACE, person, pet2, race);

    }
}
