
package org.nuiton.topia.framework;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topiatest.QueriedEntity;

/**
 *
 * @author fdesbois
 */
public class TopiaQueryTest {

    public TopiaQueryTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAdd() {

        // Test with one paramValue
        String value = "topia";
        TopiaQuery query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd = :testAdd",
                query.fullQuery());

        // Test with null paramValue
        String nullValue = null;
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, nullValue);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd IS NULL",
                query.fullQuery());

        // Test with two paramValues
        String value2 = "eugene";
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value, value2);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd IN(:testAdd1, :testAdd2)",
                query.fullQuery());

        // Test with two paramValues + null
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value, value2, null);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE (testAdd IN(:testAdd1, :testAdd2) OR testAdd IS NULL)",
                query.fullQuery());
    }

}