package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public class TypeDTO implements Serializable {

    public String name;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return name;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
         toString();
        return result;
}


} //TypeDTO
