package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetDAO;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceDAO;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.BillDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.ProductDAO;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.StoreDAO;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.TypeDAO;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Contact2DAO;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Party2DAO;
import org.nuiton.topiatest.deletetest.Telephone2;
import org.nuiton.topiatest.deletetest.Telephone2DAO;


public class TopiaTestDAOHelper {



    public enum TopiaTestEntityEnum implements TopiaEntityEnum {

        Person(Person.class),
        Pet(Pet.class),
        Race(Race.class),
        Address(Address.class),
        Bill(Bill.class),
        Company(Company.class),
        Department(Department.class),
        Employe(Employe.class),
        NaturalizedEntity(NaturalizedEntity.class),
        Personne(Personne.class),
        Product(Product.class),
        Store(Store.class),
        Type(Type.class),
        Contact2(Contact2.class),
        Party2(Party2.class),
        Telephone2(Telephone2.class);
        /**
         * the contract of the entity
         */
        protected Class<? extends TopiaEntity> contract;
        /**
         * the fully qualified name of the implementation of the entity
         */
        protected String implementationFQN;
        /**
         * the implementation class of the entity (will be lazy computed at runtime)
         */
        protected Class<? extends TopiaEntity> implementation;
        /**
         * TopiaTestEntityEnum :
             * @param contract 
     */

         TopiaTestEntityEnum(Class<? extends TopiaEntity > contract)     {
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
        }

        /**
         * getContract :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        /**
         * getImplementationFQN :
             * @return String 
     */

        public String getImplementationFQN()     {
        return implementationFQN;
        }

        /**
         * setImplementationFQN :
             * @param implementationFQN 
     */

        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        // on reinitialise le magasin d'operators
       EntityOperatorStore.clear();
        }

        /**
         * accept :
             * @param klass 
         * @return boolean 
     */

        public boolean accept(Class<? extends TopiaEntity> klass)     {
         return TopiaTestDAOHelper.getContractClass(klass) == contract;
         }

        /**
         * getImplementation :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getImplementation()     {
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
         }

        /**
         * valueOf :
             * @param entity 
         * @return TopiaTestEntityEnum 
     */

        public static TopiaTestEntityEnum valueOf(TopiaEntity entity)     {
         return valueOf(entity.getClass());
         }

        /**
         * valueOf :
             * @param klass 
         * @return TopiaTestEntityEnum 
     */

        public static TopiaTestEntityEnum valueOf(Class<?> klass)     {
         if (klass.isInterface()) {
            return TopiaTestEntityEnum.valueOf(klass.getSimpleName());
         }
         for (TopiaTestEntityEnum entityEnum : TopiaTestEntityEnum.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaTestEntityEnum.values()));
         }


    } //TopiaTestEntityEnum
        /**
         * TopiaTestDAOHelper :
         */

        protected TopiaTestDAOHelper()     {     }

        /**
         * getModelVersion :
             * @return String 
     */

        public static String getModelVersion()     {
        return "1.2";
        }

        /**
         * getModelName :
             * @return String 
     */

        public static String getModelName()     {
        return "TopiaTest";
        }

        /**
         * getPersonDAO :
             * @param context 
         * @return PersonDAO 
         * @throws TopiaException
     */

        public static PersonDAO getPersonDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonDAO result = (PersonDAO) ci.getDAO(Person.class);
        return result;
        }

        /**
         * getPetDAO :
             * @param context 
         * @return PetDAO 
         * @throws TopiaException
     */

        public static PetDAO getPetDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PetDAO result = (PetDAO) ci.getDAO(Pet.class);
        return result;
        }

        /**
         * getRaceDAO :
             * @param context 
         * @return RaceDAO 
         * @throws TopiaException
     */

        public static RaceDAO getRaceDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        RaceDAO result = (RaceDAO) ci.getDAO(Race.class);
        return result;
        }

        /**
         * getAddressDAO :
             * @param context 
         * @return AddressDAO 
         * @throws TopiaException
     */

        public static AddressDAO getAddressDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AddressDAO result = (AddressDAO) ci.getDAO(Address.class);
        return result;
        }

        /**
         * getBillDAO :
             * @param context 
         * @return BillDAO 
         * @throws TopiaException
     */

        public static BillDAO getBillDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        BillDAO result = (BillDAO) ci.getDAO(Bill.class);
        return result;
        }

        /**
         * getCompanyDAO :
             * @param context 
         * @return CompanyDAO 
         * @throws TopiaException
     */

        public static CompanyDAO getCompanyDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CompanyDAO result = (CompanyDAO) ci.getDAO(Company.class);
        return result;
        }

        /**
         * getDepartmentDAO :
             * @param context 
         * @return DepartmentDAO 
         * @throws TopiaException
     */

        public static DepartmentDAO getDepartmentDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        DepartmentDAO result = (DepartmentDAO) ci.getDAO(Department.class);
        return result;
        }

        /**
         * getEmployeDAO :
             * @param context 
         * @return EmployeDAO 
         * @throws TopiaException
     */

        public static EmployeDAO getEmployeDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EmployeDAO result = (EmployeDAO) ci.getDAO(Employe.class);
        return result;
        }

        /**
         * getNaturalizedEntityDAO :
             * @param context 
         * @return NaturalizedEntityDAO 
         * @throws TopiaException
     */

        public static NaturalizedEntityDAO getNaturalizedEntityDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        NaturalizedEntityDAO result = (NaturalizedEntityDAO) ci.getDAO(NaturalizedEntity.class);
        return result;
        }

        /**
         * getPersonneDAO :
             * @param context 
         * @return PersonneDAO 
         * @throws TopiaException
     */

        public static PersonneDAO getPersonneDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonneDAO result = (PersonneDAO) ci.getDAO(Personne.class);
        return result;
        }

        /**
         * getProductDAO :
             * @param context 
         * @return ProductDAO 
         * @throws TopiaException
     */

        public static ProductDAO getProductDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductDAO result = (ProductDAO) ci.getDAO(Product.class);
        return result;
        }

        /**
         * getStoreDAO :
             * @param context 
         * @return StoreDAO 
         * @throws TopiaException
     */

        public static StoreDAO getStoreDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StoreDAO result = (StoreDAO) ci.getDAO(Store.class);
        return result;
        }

        /**
         * getTypeDAO :
             * @param context 
         * @return TypeDAO 
         * @throws TopiaException
     */

        public static TypeDAO getTypeDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TypeDAO result = (TypeDAO) ci.getDAO(Type.class);
        return result;
        }

        /**
         * getContact2DAO :
             * @param context 
         * @return Contact2DAO 
         * @throws TopiaException
     */

        public static Contact2DAO getContact2DAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Contact2DAO result = (Contact2DAO) ci.getDAO(Contact2.class);
        return result;
        }

        /**
         * getParty2DAO :
             * @param context 
         * @return Party2DAO 
         * @throws TopiaException
     */

        public static Party2DAO getParty2DAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Party2DAO result = (Party2DAO) ci.getDAO(Party2.class);
        return result;
        }

        /**
         * getTelephone2DAO :
             * @param context 
         * @return Telephone2DAO 
         * @throws TopiaException
     */

        public static Telephone2DAO getTelephone2DAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Telephone2DAO result = (Telephone2DAO) ci.getDAO(Telephone2.class);
        return result;
        }

        /**
         * getDAO :
             * @param context 
         * @param klass 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getDAO :
             * @param context 
         * @param entity 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getContractClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass)     {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
        }

        /**
         * getImplementationClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass)     {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
        }

        /**
         * getContractClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getContractClasses()     {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
        }

        /**
         * getImplementationClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getImplementationClasses()     {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
        }

        /**
         * getImplementationClassesAsString :
             * @return String 
     */

        public static String getImplementationClassesAsString()     {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
        }

        /**
         * getContracts :
             * @return TopiaTestEntityEnum[] 
     */

        public static TopiaTestEntityEnum[] getContracts()     {
        return TopiaTestEntityEnum.values();
        }

        /**
         * getOperator :
             * @param klass 
         * @return <T extends TopiaEntity> EntityOperator<T> 
     */

        public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass)     {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);
        }


    } //TopiaTestDAOHelper
