/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

public class HorizontalEntityVisitor
implements EntityVisitor {
    private static Log log = LogFactory.getLog(HorizontalEntityVisitor.class);
    protected EntityVisitor delegateVisitor;
    protected List<TopiaEntity> alreadyExplored;
    protected List<TopiaEntity> toVisitEntities;

    public HorizontalEntityVisitor(EntityVisitor delegateVisitor) {
        this.delegateVisitor = delegateVisitor;
        this.alreadyExplored = new ArrayList<TopiaEntity>();
        this.toVisitEntities = new ArrayList<TopiaEntity>();
    }

    @Override
    public void start(TopiaEntity entity) {
        this.delegateVisitor.start(entity);
        if (!this.alreadyExplored.contains(entity)) {
            this.alreadyExplored.add(entity);
        }
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
        if (value instanceof TopiaEntity) {
            TopiaEntity entityValue = (TopiaEntity)value;
            this.toVisitEntities.add(entityValue);
        } else {
            this.delegateVisitor.visit(entity, propertyName, type, value);
        }
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        Collection values = (Collection)value;
        if (values != null && !values.isEmpty()) {
            int i = 0;
            for (Object currentValue : values) {
                this.visit(entity, propertyName, type, collectionType, i++, currentValue);
            }
        }
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
        if (value instanceof TopiaEntity) {
            TopiaEntity entityValue = (TopiaEntity)value;
            this.toVisitEntities.add(entityValue);
        } else {
            this.delegateVisitor.visit(entity, propertyName, collectionType, type, index, value);
        }
    }

    @Override
    public void end(TopiaEntity entity) {
        this.delegateVisitor.end(entity);
        ArrayList<TopiaEntity> currentEntities = new ArrayList<TopiaEntity>(this.toVisitEntities);
        this.toVisitEntities.clear();
        for (TopiaEntity currentEntity : currentEntities) {
            try {
                if (this.alreadyExplored.contains(currentEntity)) continue;
                currentEntity.accept(this);
                log.debug((Object)("Post process " + currentEntity));
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Error on horizontal exploration", (Throwable)ex);
            }
        }
    }

    @Override
    public void clear() {
        this.alreadyExplored.clear();
        this.toVisitEntities.clear();
        this.delegateVisitor.clear();
    }
}

