/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv.out;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaPersistenceHelper;
import org.nuiton.topia.persistence.csv.out.TopiaCsvExports;
import org.nuiton.util.TimeLog;

public class ExportEntityVisitor<T extends TopiaEntityEnum>
implements EntityVisitor,
Closeable {
    private static final Log log = LogFactory.getLog(ExportEntityVisitor.class);
    public static final TimeLog TIME_LOG = new TimeLog(ExportEntityVisitor.class);
    protected final Map<T, TopiaCsvExports.EntityExportContext<T>> entityExporters;
    protected final TopiaPersistenceHelper<T> persistenceHelper;

    public static <T extends TopiaEntityEnum> ExportEntityVisitor<T> newVisitor(TopiaPersistenceHelper<T> persistenceHelper, Map<T, TopiaCsvExports.EntityExportContext<T>> entityExporters) {
        return new ExportEntityVisitor<T>(persistenceHelper, entityExporters);
    }

    public ExportEntityVisitor(TopiaPersistenceHelper<T> persistenceHelper, Map<T, TopiaCsvExports.EntityExportContext<T>> entityExporters) {
        this.persistenceHelper = persistenceHelper;
        this.entityExporters = entityExporters;
    }

    public <E extends TopiaEntity> void export(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.export(entity);
        }
    }

    public void export(TopiaEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        long s1 = TimeLog.getTime();
        try {
            entity.accept(this);
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException("Could not export entity " + entity.getTopiaId(), e);
        }
        finally {
            TIME_LOG.log(s1, "export::" + entity.getTopiaId());
        }
    }

    @Override
    public void start(TopiaEntity entity) {
        String topiaId = entity.getTopiaId();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts export of entity " + topiaId));
            }
            TopiaCsvExports.EntityExportContext entityExporter = this.getEntityContext(entity.getClass());
            Preconditions.checkNotNull((Object)entityExporter);
            entityExporter.write(entity);
        }
        catch (Exception e) {
            throw new TopiaRuntimeException("Could not export entity " + entity, e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ends export of entity " + topiaId));
            }
        }
    }

    @Override
    public void end(TopiaEntity entity) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts export of association of entity " + entity.getTopiaId()));
            }
            TopiaCsvExports.EntityExportContext entityExporter = this.getEntityContext(entity.getClass());
            Preconditions.checkNotNull((Object)entityExporter);
            entityExporter.writeAssociations(entity);
        }
        catch (Exception e) {
            throw new TopiaRuntimeException("Could not export associations of entity " + entity, e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ends export of association of entity " + entity.getTopiaId()));
            }
        }
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        Collection cValue;
        if (TopiaEntity.class.isAssignableFrom(type) && this.getEntityContext(type) != null && CollectionUtils.isNotEmpty((Collection)(cValue = (Collection)value))) {
            this.visitEntityCollection(entity, propertyName, collectionType, type, cValue);
        }
    }

    protected void visitEntityCollection(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Collection<?> cValue) {
        for (Object currentValue : cValue) {
            try {
                ((TopiaEntity)currentValue).accept(this);
            }
            catch (TopiaException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Can not visit entity " + currentValue), (Throwable)e);
            }
        }
    }

    @Override
    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
    }

    @Override
    public void close() throws IOException {
        for (TopiaCsvExports.EntityExportContext<T> exportContext : this.entityExporters.values()) {
            exportContext.close();
        }
    }

    @Override
    public void clear() {
    }

    protected TopiaCsvExports.EntityExportContext getEntityContext(Class<? extends TopiaEntity> entityType) {
        T entityEnum = this.persistenceHelper.getEntityEnum(entityType);
        return entityEnum == null ? null : this.entityExporters.get(entityEnum);
    }
}

