/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

public class DepthEntityVisitor
implements EntityVisitor {
    private static Log log = LogFactory.getLog(DepthEntityVisitor.class);
    protected Collection<TopiaEntity> alreadyExplored = new ArrayList<TopiaEntity>();
    protected EntityVisitor delegateVisitor;

    public DepthEntityVisitor() {
        this(null);
    }

    public DepthEntityVisitor(EntityVisitor delegateVisitor) {
        this.delegateVisitor = delegateVisitor;
    }

    @Override
    public void start(TopiaEntity e) {
        if (this.delegateVisitor != null) {
            this.delegateVisitor.start(e);
        }
        if (!this.alreadyExplored.contains(e)) {
            this.alreadyExplored.add(e);
        }
    }

    @Override
    public void visit(TopiaEntity e, String propertyName, Class<?> type, Object value) {
        block6: {
            if (value instanceof TopiaEntity) {
                TopiaEntity entity = (TopiaEntity)value;
                try {
                    if (!this.alreadyExplored.contains(entity)) {
                        entity.accept(this);
                    }
                    break block6;
                }
                catch (TopiaException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error on depth exploration", (Throwable)e1);
                    }
                    break block6;
                }
            }
            if (this.delegateVisitor != null) {
                this.delegateVisitor.visit(e, propertyName, type, value);
            }
        }
    }

    @Override
    public void visit(TopiaEntity e, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        Collection cValue = (Collection)value;
        if (cValue != null && !cValue.isEmpty()) {
            int i = 0;
            for (Object currentValue : cValue) {
                this.visit(e, propertyName, type, collectionType, i++, currentValue);
            }
        }
    }

    @Override
    public void visit(TopiaEntity e, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
        block6: {
            if (value instanceof TopiaEntity) {
                TopiaEntity entity = (TopiaEntity)value;
                try {
                    if (!this.alreadyExplored.contains(entity)) {
                        entity.accept(this);
                    }
                    break block6;
                }
                catch (TopiaException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error on depth exploration", (Throwable)e1);
                    }
                    break block6;
                }
            }
            if (this.delegateVisitor != null) {
                this.delegateVisitor.visit(e, propertyName, collectionType, type, index, value);
            }
        }
    }

    @Override
    public void end(TopiaEntity e) {
        if (this.delegateVisitor != null) {
            this.delegateVisitor.end(e);
        }
    }

    @Override
    public void clear() {
        this.alreadyExplored.clear();
        if (this.delegateVisitor != null) {
            this.delegateVisitor.clear();
        }
    }
}

