/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class CellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected PropertyEditor editor;
    protected int clickCountToStart = 1;

    public CellEditorAdapter(PropertyEditor editor) {
        this.editor = editor;
        Component component = editor.getCustomEditor();
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            field.addActionListener(new CommitEditing());
            field.registerKeyboardAction(new CancelEditing(), KeyStroke.getKeyStroke(27, 0), 0);
        }
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CellEditorAdapter.this.stopCellEditing();
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getEditor(value);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        return this.getEditor(value);
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private Component getEditor(Object value) {
        this.editor.setValue(value);
        final Component cellEditor = this.editor.getCustomEditor();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                cellEditor.requestFocus();
            }
        });
        return cellEditor;
    }

    class CancelEditing
    implements ActionListener {
        CancelEditing() {
        }

        public void actionPerformed(ActionEvent e) {
            CellEditorAdapter.this.cancelCellEditing();
        }
    }

    class CommitEditing
    implements ActionListener {
        CommitEditing() {
        }

        public void actionPerformed(ActionEvent e) {
            CellEditorAdapter.this.stopCellEditing();
        }
    }
}

