/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.nuiton.scmwebeditor.api.OperationNotSupportedException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.ScmRevision;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.ScmWebEditorMainAction;

public class EditAction
extends ScmWebEditorMainAction {
    private static final Log log = LogFactory.getLog(EditAction.class);
    protected static final String NOT_EDITABLE = "notEditable";
    protected String selectedBranch;
    protected boolean scmSupportsBranches;
    protected boolean scmSupportsPush;
    protected String repositoryRoot;
    protected int autoSaveInterval;
    protected Map<ScmRevision, String> revisions;
    protected String revision1;
    protected String revision2;
    protected boolean fileDirectlyAccessible;

    public String getCodeMirrorVersion() {
        return ScmWebEditorConfig.getCodeMirrorVersion();
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public void setSelectedBranch(String selectedBranch) {
        this.selectedBranch = selectedBranch;
    }

    public boolean isScmSupportsBranches() {
        return this.scmSupportsBranches;
    }

    public void setScmSupportsBranches(boolean scmSupportsBranches) {
        this.scmSupportsBranches = scmSupportsBranches;
    }

    public boolean isScmSupportsPush() {
        return this.scmSupportsPush;
    }

    public void setScmSupportsPush(boolean scmSupportsPush) {
        this.scmSupportsPush = scmSupportsPush;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
    }

    public Map<ScmRevision, String> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(Map<ScmRevision, String> revisions) {
        this.revisions = revisions;
    }

    public String getRevision1() {
        return this.revision1;
    }

    public void setRevision1(String revision1) {
        this.revision1 = revision1;
    }

    public String getRevision2() {
        return this.revision2;
    }

    public void setRevision2(String revision2) {
        this.revision2 = revision2;
    }

    public boolean isFileDirectlyAccessible() {
        return this.fileDirectlyAccessible;
    }

    public void setFileDirectlyAccessible(boolean fileDirectlyAccessible) {
        this.fileDirectlyAccessible = fileDirectlyAccessible;
    }

    public String execute() {
        String originalText;
        block47: {
            String password;
            String name;
            String repositoryUUID;
            String fileName;
            ScmConnection scmConn;
            block46: {
                String changeBranchError;
                block45: {
                    this.autoSaveInterval = ScmWebEditorConfig.getAutoSaveInterval();
                    HttpSession session = this.request.getSession();
                    String sessionId = session.getId();
                    String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
                    ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
                    scmConn = provider.getConnection(this.address, pathToLocalRepos);
                    this.fileDirectlyAccessible = provider.filesDirectlyAccessible();
                    this.scmSupportsBranches = provider.supportsBranches();
                    this.scmSupportsPush = provider.supportsPush();
                    fileName = scmConn.getFileName();
                    this.format = fileName.substring(fileName.lastIndexOf(".") + 1);
                    if ("vm".equals(this.format)) {
                        fileName = fileName.substring(0, fileName.length() - 3);
                        this.format = fileName.substring(fileName.lastIndexOf(".") + 1);
                    }
                    originalText = "";
                    repositoryUUID = scmConn.getRepositoryId();
                    if (repositoryUUID == null) {
                        repositoryUUID = this.address.replace(' ', '_');
                        repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
                    }
                    if (this.repositoryRoot == null) {
                        this.repositoryRoot = this.address.substring(0, this.address.lastIndexOf(47));
                    } else if (this.repositoryRoot.equals("")) {
                        this.repositoryRoot = this.address.substring(0, this.address.lastIndexOf(47));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Login : " + this.username));
                    }
                    String usernamepwCookie = null;
                    BlowfishCipherService bf = new BlowfishCipherService();
                    byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
                    if (this.request.getCookies() != null) {
                        for (Cookie c : this.request.getCookies()) {
                            if (!c.getName().equals(repositoryUUID)) continue;
                            usernamepwCookie = c.getValue();
                        }
                    }
                    if (usernamepwCookie != null) {
                        String[] resCookie;
                        String usernameDecode;
                        block43: {
                            usernameDecode = null;
                            try {
                                usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                if (!log.isErrorEnabled()) break block43;
                                log.error((Object)"Can not create a String with UTF-8 encoding");
                            }
                        }
                        if (usernameDecode != null && (resCookie = usernameDecode.split(",")).length == 2) {
                            this.username = resCookie[0];
                            this.pw = resCookie[1];
                        }
                    }
                    if (this.saveCookie && this.username != null && this.pw != null && !this.username.equals("") && !this.pw.equals("")) {
                        Cookie authCookie;
                        block44: {
                            authCookie = null;
                            try {
                                authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes("UTF-8"), privateKey).toBase64());
                            }
                            catch (UnsupportedEncodingException e) {
                                if (!log.isErrorEnabled()) break block44;
                                log.error((Object)"Can not get a String from UTF-8 encoding");
                            }
                        }
                        if (authCookie != null) {
                            authCookie.setMaxAge(31536000);
                            this.response.addCookie(authCookie);
                        }
                    }
                    String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
                    this.username = usernamePw[0];
                    this.pw = usernamePw[1];
                    name = this.username;
                    password = this.pw;
                    if (name == null) {
                        name = "anonymous";
                    }
                    if (password == null) {
                        password = "anonymous";
                    }
                    changeBranchError = null;
                    if (this.scmSupportsBranches) {
                        try {
                            if (this.selectedBranch == null) {
                                this.selectedBranch = provider.getDefaultBranchName();
                            } else if (this.selectedBranch.equals("")) {
                                this.selectedBranch = provider.getDefaultBranchName();
                            }
                            changeBranchError = provider.changeBranch(this.selectedBranch, pathToLocalRepos, this.username, this.pw);
                        }
                        catch (OperationNotSupportedException e) {
                            if (!log.isErrorEnabled()) break block45;
                            log.error((Object)("Can not change branch with SCM '" + this.scmType + "'"));
                        }
                    }
                }
                if (changeBranchError != null) {
                    if (changeBranchError.equals("auth error")) {
                        return "login";
                    }
                    return "errorPath";
                }
                try {
                    this.revisions = scmConn.getRevisions(this.address, this.username, this.pw);
                }
                catch (AuthenticationException e) {
                    if (!log.isErrorEnabled()) break block46;
                    log.error((Object)("Can not get revisions for address " + this.address + " : authentication error"), (Throwable)e);
                }
            }
            try {
                File originalFile = scmConn.getFileContent(this.address, name, password);
                originalText = FileUtils.readFileToString((File)originalFile);
                this.numRevision = scmConn.getHeadRevisionNumber(this.address, name, password);
            }
            catch (AuthenticationException e) {
                this.request.setAttribute("address", (Object)this.address);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Auth Fail ", (Throwable)e);
                }
                for (Cookie c : this.request.getCookies()) {
                    if (!c.getName().equals(repositoryUUID)) continue;
                    c.setMaxAge(0);
                    this.response.addCookie(c);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Cookie supprim\u00e9");
                }
                this.getScmSession().delScmUser(repositoryUUID);
                return "login";
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not read content file", (Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"The file does not exist", (Throwable)e);
                }
                return "errorPath";
            }
            this.mimeType = null;
            try {
                this.mimeType = this.getMimeType(originalText, fileName);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block47;
                log.error((Object)"Can't get MimeType, problem when reading file", (Throwable)e);
            }
        }
        LinkedList<String> editableFiles = new LinkedList<String>();
        editableFiles.add("text");
        editableFiles.add("xml");
        editableFiles.add("x-java");
        editableFiles.addAll(ScmWebEditorConfig.getEditableFiles());
        boolean editable = false;
        if (this.mimeType != null) {
            for (String fileType : editableFiles) {
                if (!this.mimeType.matches(".*" + fileType + ".*")) continue;
                editable = true;
            }
        }
        if (this.mimeType == null || !editable) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't edit this file, mimetype : " + this.mimeType));
            }
            return NOT_EDITABLE;
        }
        this.origText = originalText;
        if (log.isInfoEnabled()) {
            log.info((Object)("IP client : " + this.request.getRemoteAddr() + ", get file : " + this.address + ". File's mimetype : " + this.mimeType));
        }
        return "editPage";
    }
}

