/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.ProcessorReader;
import org.nuiton.processor.ProcessorWriter;
import org.nuiton.processor.filters.Filter;
import org.nuiton.processor.filters.NoActionFilter;

public class Processor {
    private static final Log log = LogFactory.getLog(Processor.class);
    protected Filter[] inputFilter = new Filter[]{new NoActionFilter()};
    protected Filter outputFilter = new NoActionFilter();

    public Processor() {
    }

    public Processor(Filter[] filters) {
        this.setInputFilter(filters);
    }

    public void setInputFilter(Filter inFilter) {
        this.setInputFilter(new Filter[]{inFilter});
    }

    public void setInputFilter(Filter[] inFilter) {
        this.inputFilter = inFilter;
    }

    public void setOutputFilter(Filter outFilter) {
        this.outputFilter = outFilter;
    }

    protected BufferedReader getReader(Reader externalInput) {
        BufferedReader result = new BufferedReader(externalInput);
        for (Filter anInputFilter : this.inputFilter) {
            result = new ProcessorReader(result, anInputFilter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Reader externalInput, Writer externalOutput) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Debug du process");
        }
        BufferedReader input = this.getReader(externalInput);
        try {
            BufferedWriter writer = new BufferedWriter(externalOutput);
            try {
                ProcessorWriter output = new ProcessorWriter(writer, this.outputFilter);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("input: " + input));
                    log.trace((Object)("output: " + output));
                }
                String line = input.readLine();
                while (line != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Ligne lu: " + line));
                    }
                    output.writeLine(line);
                    line = input.readLine();
                }
                output.flush();
            }
            finally {
                writer.close();
            }
        }
        finally {
            input.close();
        }
    }
}

