/* *##% Graphical Widget
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * Mailor.java
 *
 * Created: Nov 29, 2004
 *
 * @author C�dric Pineau <pineau@codelutin.com>
 * @version $Revision: 184 $
 *
 * Last update : $Date: 2009-05-16 06:01:36 +0200 (sam., 16 mai 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.widget;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/**
 *  
 */
public class Mailor {

    public static void main(String[] args) {
        try {

            List<FileInputStream> bodyPartStreams = new ArrayList<FileInputStream>();
            bodyPartStreams.add(new FileInputStream(
                    "/home/pineau/mailing/dej2-1"));
            bodyPartStreams.add(new FileInputStream(
                    "/home/pineau/mailing/dej2-2"));
            bodyPartStreams.add(new FileInputStream(
                    "/home/pineau/mailing/dej2-3"));

            List<String> tos = new ArrayList<String>();
            BufferedReader bfr = new BufferedReader(new FileReader(
                    "/home/pineau/mailing/listMails-NO"));
            while (bfr.ready()) {
                tos.add(bfr.readLine());
            }

            new Mailor()
                    .send(
                            "localhost",
                            tos,
                            "geraldine.renaud@carra.fr",
                            "=?iso-8859-1?Q?_Petit-D=E9jeuner_:_le_d=E9veloppement_Java_J2EE_et_l'open?==?iso-8859-1?Q?_source?=",
                            bodyPartStreams);
        } catch (AddressException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (MessagingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * Send an email using the given informations (stmpServer, toAddress,
     * fromAddress, subject and body).
     * 
     * @param smtpServer
     * @param tos
     * @param from
     * @param subject
     * @param bodyParts
     * @throws MessagingException
     * @throws IOException
     */
    protected void send(String smtpServer, List<?> tos, String from,
            String subject, List<?> bodyParts) throws MessagingException,
            IOException {
        Properties props = System.getProperties();

        // -- Attaching to default Session, or we could start a new one --
        props.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance(props, null);

        // -- Create a new message --
        MimeMessage msg = new MimeMessage(session);

        // -- Set the FROM and TO fields --
        msg.setFrom(new InternetAddress(from));
        // -- Set the subject and body text --
        msg.setSubject(subject);

        // for (Iterator iter = bodyParts.iterator(); iter.hasNext();) {
        // InputStream element = (InputStream) iter.next();
        // body.addBodyPart(new MimeBodyPart(element));
        // }

        MimeMultipart alt = new MimeMultipart("alternative");
        alt.addBodyPart(new MimeBodyPart((InputStream) bodyParts.get(0)));
        alt.addBodyPart(new MimeBodyPart((InputStream) bodyParts.get(1)));
        MimeBodyPart altPart = new MimeBodyPart();
        altPart.setContent(alt);

        BodyPart attPart = new MimeBodyPart((InputStream) bodyParts.get(2));
        attPart.setDisposition(Part.ATTACHMENT);

        MimeMultipart body = new MimeMultipart("mixed");
        body.addBodyPart(altPart);
        body.addBodyPart(attPart);

        msg.setContent(body);

        // -- Set some other header information --
        msg.setHeader("X-Mailer", "Code Lutin Java Mailer");
        msg.setSentDate(new Date());

        for (Object to1 : tos) {
            String to = (String) to1;
            System.out.println("mailing to " + to); // TODO remove this
            try {
                msg.setRecipients(Message.RecipientType.TO, InternetAddress
                        .parse(to, false));

                // -- Send the message --
                Transport.send(msg);
            } catch (Exception e) {
                // TODO: handle exception
                e.printStackTrace();
                System.out.println("while mailing to " + to); // TODO remove
                                                              // this
            }
        }
    }
}
