/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.model;

import java.io.File;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.validator.AbstractValidatorDetectorTest;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.model.Person;
import org.nuiton.validator.model.Pet;

public class ModelValidatorDetectorTestImpl
extends AbstractValidatorDetectorTest {
    public static final String CONTEXT = "context";

    public ModelValidatorDetectorTestImpl() {
        super("xwork2");
    }

    @Override
    protected File getRootDirectory(File basedir) {
        File testResourcesDir = new File(basedir, "src" + File.separator + "test" + File.separator + "resources");
        return testResourcesDir;
    }

    @Test
    public void detectAllValidators() {
        SortedSet<NuitonValidator<?>> result = this.detectValidators(Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator iterator = result.iterator();
        NuitonValidator validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, null, Person.class, NuitonValidatorScope.values());
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.ERROR, NuitonValidatorScope.WARNING);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.ERROR, "name", "firstname");
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.WARNING, "pet");
        validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, null, Pet.class, NuitonValidatorScope.values());
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.ERROR);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.ERROR, "name");
        validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, CONTEXT, Pet.class, NuitonValidatorScope.values());
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.INFO);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.INFO, "name");
    }

    @Test
    public void detectValidatorsWithFilteredScopes() {
        SortedSet<NuitonValidator<?>> result = this.detectValidators(null, new NuitonValidatorScope[]{NuitonValidatorScope.WARNING}, Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Iterator iterator = result.iterator();
        NuitonValidator validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, null, Person.class, NuitonValidatorScope.WARNING);
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.WARNING);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.WARNING, "pet");
        result = this.detectValidators(null, new NuitonValidatorScope[]{NuitonValidatorScope.FATAL}, Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void detectValidatorsWithFilteredContext() {
        SortedSet<NuitonValidator<?>> result = this.detectValidators(Pattern.compile(CONTEXT), Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Iterator iterator = result.iterator();
        NuitonValidator validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, CONTEXT, Pet.class, NuitonValidatorScope.values());
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.INFO);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.INFO, "name");
        result = this.detectValidators(Pattern.compile(".*-fake"), Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void detectValidatorsWithFilteredContextAndFilteredScope() {
        SortedSet<NuitonValidator<?>> result = this.detectValidators(Pattern.compile(CONTEXT), new NuitonValidatorScope[]{NuitonValidatorScope.INFO, NuitonValidatorScope.FATAL}, Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Iterator iterator = result.iterator();
        NuitonValidator validator = (NuitonValidator)iterator.next();
        this.assertValidatorModel(validator, CONTEXT, Pet.class, NuitonValidatorScope.FATAL, NuitonValidatorScope.INFO);
        this.assertValidatorEffectiveScopes(validator, NuitonValidatorScope.INFO);
        this.assertValidatorEffectiveFields(validator, NuitonValidatorScope.INFO, "name");
        result = this.detectValidators(Pattern.compile(".*-fake"), new NuitonValidatorScope[]{NuitonValidatorScope.FATAL}, Person.class, Pet.class);
        Assert.assertNotNull(result);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

