/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayByteList;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteListIterator;

public final class ByteCollections {
    public static final ByteList EMPTY_BYTE_LIST = ByteCollections.unmodifiableByteList(new ArrayByteList(0));
    public static final ByteIterator EMPTY_BYTE_ITERATOR = ByteCollections.unmodifiableByteIterator(EMPTY_BYTE_LIST.iterator());
    public static final ByteListIterator EMPTY_BYTE_LIST_ITERATOR = ByteCollections.unmodifiableByteListIterator(EMPTY_BYTE_LIST.listIterator());

    public static ByteList singletonByteList(byte value) {
        ArrayByteList list = new ArrayByteList(1);
        list.add(value);
        return UnmodifiableByteList.wrap(list);
    }

    public static ByteIterator singletonByteIterator(byte value) {
        return ByteCollections.singletonByteList(value).iterator();
    }

    public static ByteListIterator singletonByteListIterator(byte value) {
        return ByteCollections.singletonByteList(value).listIterator();
    }

    public static ByteList unmodifiableByteList(ByteList list) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        return UnmodifiableByteList.wrap(list);
    }

    public static ByteIterator unmodifiableByteIterator(ByteIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableByteIterator.wrap(iter);
    }

    public static ByteListIterator unmodifiableByteListIterator(ByteListIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableByteListIterator.wrap(iter);
    }

    public static ByteList getEmptyByteList() {
        return EMPTY_BYTE_LIST;
    }

    public static ByteIterator getEmptyByteIterator() {
        return EMPTY_BYTE_ITERATOR;
    }

    public static ByteListIterator getEmptyByteListIterator() {
        return EMPTY_BYTE_LIST_ITERATOR;
    }
}

